/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.restart.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.events.RestartEvents;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.restart.RestartModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class RestartCommand
extends ModCommand<RestartModule> {
    public RestartCommand(RestartModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("restart");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(4))).then(class_2170.method_9247((String)"now").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Restarting server"), true);
            ((RestartModule)this.module).restart();
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"schedule").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"timespan", (ArgumentType)StringArgumentType.word()).suggests(TimeSpan::suggest).executes(context -> this.schedule((CommandContext<class_2168>)context, TimeSpan.getTimeSpan((CommandContext<class_2168>)context, "timespan"), null))).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.schedule((CommandContext<class_2168>)context, TimeSpan.getTimeSpan((CommandContext<class_2168>)context, "timespan"), StringArgumentType.getString((CommandContext)context, (String)"message")))))).then(class_2170.method_9247((String)"next").executes(this::scheduleNext)))).then(class_2170.method_9247((String)"cancel").executes(this::cancel));
    }

    private int schedule(CommandContext<class_2168> context, int seconds, @Nullable String message) {
        if (((RestartModule)this.module).isRunning()) {
            ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"There is already a running restart."));
            return 0;
        }
        if (message == null) {
            message = ((RestartModule)this.module).locale().raw("barLabel");
        }
        ((RestartModule)this.module).schedule(seconds, message, RestartEvents.RestartType.MANUAL);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)("Manual restart scheduled in " + seconds + " seconds.")), true);
        return 1;
    }

    private int scheduleNext(CommandContext<class_2168> context) {
        if (((RestartModule)this.module).isScheduled()) {
            ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"There is already a scheduled restart."));
            return 0;
        }
        Long delay = ((RestartModule)this.module).scheduleNextRestart();
        if (delay == null) {
            ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"Could not schedule next automatic restart."));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Next automatic restart scheduled in " + delay + " seconds.")), true);
        return 1;
    }

    private int cancel(CommandContext<class_2168> context) {
        if (!((RestartModule)this.module).isScheduled()) {
            ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"There is no scheduled restart."));
            return 0;
        }
        ((RestartModule)this.module).cancel();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Restart schedule canceled."), true);
        return 1;
    }
}

