/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.seen.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.core.coreModule.CoreModule;
import me.alexdevs.solstice.core.coreModule.data.CoreConfig;
import me.alexdevs.solstice.core.coreModule.data.CorePlayerData;
import me.alexdevs.solstice.modules.seen.SeenModule;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class SeenCommand
extends ModCommand<SeenModule> {
    public SeenCommand(SeenModule module) {
        super(module);
    }

    public static String getPositionAsString(@Nullable ServerLocation pos) {
        if (pos == null) {
            return "Unknown position";
        }
        return String.format("%.01f %.01f %.01f, %s", pos.getX(), pos.getY(), pos.getZ(), pos.getWorld());
    }

    @Override
    public List<String> getNames() {
        return List.of("seen", "playerinfo");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(true))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests(LocalGameProfile::suggest).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            GameProfile profile = LocalGameProfile.getProfile((CommandContext<class_2168>)context, "player");
            boolean extended = ((class_2168)context.getSource()).method_43737() ? Permissions.check((class_1297)((class_2168)context.getSource()).method_44023(), (String)this.getPermissionNode("extended"), (int)2) : true;
            CoreConfig config = CoreModule.getConfig();
            SimpleDateFormat dateFormatter = new SimpleDateFormat(config.dateTimeFormat);
            class_3222 player = source.method_9211().method_3760().method_14602(profile.getId());
            CorePlayerData playerData = CoreModule.getPlayerData(profile.getId());
            if (playerData.firstJoinedDate == null) {
                source.method_9226(() -> ((SeenModule)this.module).locale().get("playerNotFound"), false);
                return 0;
            }
            ServerLocation location = player == null ? playerData.logoffPosition : new ServerLocation(player);
            String firstSeenDate = playerData.firstJoinedDate != null ? dateFormatter.format(playerData.firstJoinedDate) : ((SeenModule)this.module).locale().raw("neverJoined");
            String lastSeenDate = playerData.lastSeenDate != null ? dateFormatter.format(playerData.lastSeenDate) : ((SeenModule)this.module).locale().raw("unknown");
            String ipAddress = playerData.ipAddress != null ? playerData.ipAddress : ((SeenModule)this.module).locale().raw("unknown");
            Map<String, class_2561> map = Map.of("username", class_2561.method_30163((String)profile.getName()), "uuid", class_2561.method_30163((String)profile.getId().toString()), "firstSeenDate", class_2561.method_30163((String)firstSeenDate), "lastSeenDate", class_2561.method_30163((String)(player != null ? ((SeenModule)this.module).locale().raw("online") : lastSeenDate)), "ipAddress", class_2561.method_30163((String)ipAddress), "location", class_2561.method_30163((String)SeenCommand.getPositionAsString(location)));
            Object outputString = ((SeenModule)this.module).locale().raw("base");
            if (extended) {
                outputString = (String)outputString + "\n";
                outputString = (String)outputString + ((SeenModule)this.module).locale().raw("extended");
            }
            String finalOutput = outputString;
            if (player != null) {
                source.method_9226(() -> Format.parse(finalOutput, PlaceholderContext.of((class_3222)player), map), false);
            } else {
                source.method_9226(() -> Format.parse(finalOutput, PlaceholderContext.of((MinecraftServer)source.method_9211()), map), false);
            }
            return 1;
        }));
    }
}

