/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.spawn.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.spawn.SpawnModule;
import me.alexdevs.solstice.modules.spawn.data.SpawnConfig;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class SpawnCommand
extends ModCommand<SpawnModule> {
    public SpawnCommand(SpawnModule module) {
        super(module);
    }

    private int execute(CommandContext<class_2168> context, @Nullable class_3218 world, @Nullable Collection<class_3222> players) throws CommandSyntaxException {
        SpawnConfig config = ((SpawnModule)this.module).getConfig();
        boolean skipPermCheck = false;
        if (world == null) {
            if (config.globalSpawn.onSpawnCommand) {
                world = ((SpawnModule)this.module).getGlobalSpawnWorld();
                skipPermCheck = true;
            } else {
                world = ((class_2168)context.getSource()).method_9225();
            }
        }
        String worldName = world.method_27983().method_29177().toString();
        if (config.requireWorldPermission && !skipPermCheck && !Permissions.check((class_2172)((class_2172)context.getSource()), (String)this.getPermissionNode("worlds." + worldName), (int)2)) {
            ((class_2168)context.getSource()).method_9226(() -> ((SpawnModule)this.module).locale().get("noWorldPermission", Map.of("world", class_2561.method_30163((String)worldName))), false);
            return 0;
        }
        if (players == null) {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            this.sendToSpawn(context, player, world);
            return 1;
        }
        for (class_3222 player : players) {
            this.sendToSpawn(context, player, world);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Sent ").method_10852(player.method_5476()).method_27693(" to " + worldName + " spawn."), true);
        }
        return players.size();
    }

    private void sendToSpawn(CommandContext<class_2168> context, class_3222 player, class_3218 world) {
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        ((class_2168)context.getSource()).method_9226(() -> ((SpawnModule)this.module).locale().get("teleporting", playerContext), false);
        ((SpawnModule)this.module).sendToSpawn(player, world);
    }

    @Override
    public List<String> getNames() {
        return List.of("spawn");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(true))).executes(context -> this.execute((CommandContext<class_2168>)context, null, null))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288()).requires(this.require("worlds.base", true))).executes(context -> this.execute((CommandContext<class_2168>)context, class_2181.method_9289((CommandContext)context, (String)"world"), null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).requires(this.require("others", 2))).executes(context -> this.execute((CommandContext<class_2168>)context, class_2181.method_9289((CommandContext)context, (String)"world"), class_2186.method_9312((CommandContext)context, (String)"players")))));
    }
}

