/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.staffChat;

import eu.pb4.placeholders.api.node.TextNode;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.api.text.parser.MarkdownParser;
import me.alexdevs.solstice.modules.staffChat.commands.StaffChatCommand;
import me.alexdevs.solstice.modules.staffChat.data.StaffChatLocale;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class StaffChatModule
extends ModuleBase.Toggleable {
    private final ConcurrentHashMap<UUID, Boolean> stickyStaffChat = new ConcurrentHashMap();

    public StaffChatModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerLocale(StaffChatLocale.MODULE);
        this.commands.add(new StaffChatCommand(this));
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, player, pars) -> {
            if (this.stickyStaffChat.getOrDefault(player.method_5667(), false).booleanValue() && this.canUseStaffChat(player)) {
                this.sendStaffChatMessage(player.method_5476(), message.method_46291());
                return false;
            }
            return true;
        });
    }

    public boolean canUseStaffChat(class_3222 player) {
        return Permissions.check((class_1297)player, (String)this.getPermissionNode("base"), (int)1);
    }

    public void sendStaffChatMessage(class_2561 sourceName, class_2561 message) {
        class_2561 formattedMessage = MarkdownParser.defaultParser.parseNode(TextNode.convert((class_2561)message)).toText();
        class_2561 text = this.locale().get("message", Map.of("name", sourceName, "message", formattedMessage));
        Solstice.server.method_43496(text);
        Solstice.server.method_3760().method_14571().forEach(player -> {
            if (this.canUseStaffChat((class_3222)player)) {
                player.method_7353(text, false);
            }
        });
    }

    public boolean toggleStaffChat(UUID uuid) {
        boolean val = this.stickyStaffChat.getOrDefault(uuid, false) == false;
        this.stickyStaffChat.put(uuid, val);
        return val;
    }
}

