/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.teleportRequest;

import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.api.text.Components;
import me.alexdevs.solstice.modules.notifications.NotificationsModule;
import me.alexdevs.solstice.modules.teleportRequest.commands.TeleportAcceptCommand;
import me.alexdevs.solstice.modules.teleportRequest.commands.TeleportAskCommand;
import me.alexdevs.solstice.modules.teleportRequest.commands.TeleportAskHereCommand;
import me.alexdevs.solstice.modules.teleportRequest.commands.TeleportDenyCommand;
import me.alexdevs.solstice.modules.teleportRequest.data.Request;
import me.alexdevs.solstice.modules.teleportRequest.data.TeleportConfig;
import me.alexdevs.solstice.modules.teleportRequest.data.TeleportLocale;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class TeleportRequestModule
extends ModuleBase.Toggleable {
    private final Map<UUID, ConcurrentLinkedDeque<Request>> requests = new ConcurrentHashMap<UUID, ConcurrentLinkedDeque<Request>>();

    public TeleportRequestModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerConfig(TeleportConfig.class, TeleportConfig::new);
        this.registerLocale(TeleportLocale.MODULE);
        this.commands.add(new TeleportAcceptCommand(this));
        this.commands.add(new TeleportAskCommand(this));
        this.commands.add(new TeleportAskHereCommand(this));
        this.commands.add(new TeleportDenyCommand(this));
        Solstice.scheduler.scheduleAtFixedRate(this::tickDown, 0L, 1L, TimeUnit.SECONDS);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.requests.put(handler.method_32311().method_5667(), new ConcurrentLinkedDeque()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> Solstice.nextTick(() -> this.requests.remove(handler.method_32311().method_5667())));
    }

    private void tickDown() {
        for (Map.Entry<UUID, ConcurrentLinkedDeque<Request>> entry : this.requests.entrySet()) {
            entry.getValue().removeIf(Request::tickDown);
        }
    }

    public TeleportConfig getConfig() {
        return Solstice.configManager.getData(TeleportConfig.class);
    }

    public Request getRequestFromSource(class_3222 player, class_3222 source) {
        return this.requests.get(player.method_5667()).stream().filter(r -> r.getSource().method_5667().equals(source.method_5667())).findFirst().orElse(null);
    }

    public Request getLatestRequest(class_3222 player) {
        ConcurrentLinkedDeque<Request> reqs = this.requests.get(player.method_5667());
        if (reqs.isEmpty()) {
            return null;
        }
        return reqs.getLast();
    }

    public void acceptRequest(class_3222 player, Request request) {
        this.requests.get(player.method_5667()).remove(request);
        class_3222 source = request.getSource();
        Request.Direction direction = request.getDirection();
        Map<String, class_2561> map = Map.of("player", player.method_5476());
        player.method_43496(this.locale().get("targetAccepted"));
        source.method_43496(this.locale().get("sourceAccepted", map));
        if (direction == Request.Direction.SOURCE_TO_TARGET) {
            ServerLocation location = new ServerLocation(player);
            location.teleport(source);
        } else {
            ServerLocation location = new ServerLocation(source);
            location.teleport(player);
        }
    }

    public void refuseRequest(class_3222 player, Request request) {
        this.requests.get(player.method_5667()).remove(request);
        class_3222 source = request.getSource();
        Map<String, class_2561> map = Map.of("player", player.method_5476());
        player.method_43496(this.locale().get("targetRefused"));
        source.method_43496(this.locale().get("sourceRefused", map));
    }

    public void requestTo(class_3222 source, class_3222 target) {
        Request request = new Request(source, this.getConfig().teleportRequestTimeout, Request.Direction.SOURCE_TO_TARGET);
        this.requests.computeIfAbsent(target.method_5667(), uuid -> new ConcurrentLinkedDeque()).add(request);
        PlaceholderContext sourceContext = PlaceholderContext.of((class_3222)source);
        PlaceholderContext targetContext = PlaceholderContext.of((class_3222)target);
        Map<String, class_2561> placeholders = Map.of("requesterPlayer", source.method_5476(), "acceptButton", Components.button(this.locale().raw("~accept"), this.locale().raw("~accept.hover"), "/tpaccept " + source.method_7334().getName()), "refuseButton", Components.button(this.locale().raw("~refuse"), this.locale().raw("~refuse.hover"), "/tpdeny " + source.method_7334().getName()));
        target.method_43496(this.locale().get("pendingTeleport", targetContext, placeholders));
        source.method_43496(this.locale().get("requestSent", sourceContext));
        NotificationsModule.notify(target);
    }

    public void requestToHere(class_3222 source, class_3222 target) {
        Request request = new Request(source, this.getConfig().teleportRequestTimeout, Request.Direction.TARGET_TO_SOURCE);
        this.requests.computeIfAbsent(target.method_5667(), uuid -> new ConcurrentLinkedDeque()).add(request);
        PlaceholderContext sourceContext = PlaceholderContext.of((class_3222)source);
        PlaceholderContext targetContext = PlaceholderContext.of((class_3222)target);
        Map<String, class_2561> placeholders = Map.of("requesterPlayer", source.method_5476(), "acceptButton", Components.button(this.locale().raw("~accept"), this.locale().raw("~accept.hover"), "/tpaccept " + source.method_7334().getName()), "refuseButton", Components.button(this.locale().raw("~refuse"), this.locale().raw("~refuse.hover"), "/tpdeny " + source.method_7334().getName()));
        target.method_43496(this.locale().get("pendingTeleportHere", targetContext, placeholders));
        source.method_43496(this.locale().get("requestSent", sourceContext));
        NotificationsModule.notify(target);
    }
}

