/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.timeBar;

import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.Map;
import java.util.UUID;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.text.Format;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3002;
import net.minecraft.server.MinecraftServer;

public class TimeBar {
    private final UUID uuid = UUID.randomUUID();
    private final class_3002 bossBar;
    private final String label;
    private final int time;
    private final boolean countdown;
    private int elapsedSeconds = 0;

    public TimeBar(String label, int time, boolean countdown, class_1259.class_1260 color, class_1259.class_1261 style) {
        this.bossBar = new class_3002(class_2960.method_43902((String)"solstice", (String)this.uuid.toString()), class_2561.method_30163((String)label));
        this.bossBar.method_5416(color);
        this.bossBar.method_5409(style);
        this.label = label;
        this.time = time;
        this.countdown = countdown;
        this.updateName();
        this.updateProgress();
    }

    public void updateName() {
        class_2561 text = this.parseLabel(this.label);
        this.bossBar.method_5413(text);
    }

    public class_2561 parseLabel(String labelString) {
        String totalTime = TimeSpan.toLongString(this.time);
        String elapsedTime = TimeSpan.toLongString(this.elapsedSeconds);
        int remaining = this.getRemainingSeconds();
        String remainingTime = TimeSpan.toLongString(remaining);
        Map<String, class_2561> placeholders = Map.of("total_time", class_2561.method_30163((String)totalTime), "elapsed_time", class_2561.method_30163((String)elapsedTime), "remaining_time", class_2561.method_30163((String)remainingTime));
        PlaceholderContext serverContext = PlaceholderContext.of((MinecraftServer)Solstice.server);
        return Format.parse(labelString, serverContext, placeholders);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public class_3002 getBossBar() {
        return this.bossBar;
    }

    public String getLabel() {
        return this.label;
    }

    public int getTime() {
        return this.time;
    }

    public int getElapsedSeconds() {
        return this.elapsedSeconds;
    }

    public int getRemainingSeconds() {
        return this.time - this.elapsedSeconds;
    }

    public boolean isCountdown() {
        return this.countdown;
    }

    public boolean elapse() {
        ++this.elapsedSeconds;
        this.updateProgress();
        this.updateName();
        return this.elapsedSeconds >= this.time;
    }

    private void updateProgress() {
        float progress = (float)this.elapsedSeconds / (float)this.time;
        if (this.countdown) {
            progress = 1.0f - progress;
        }
        this.bossBar.method_5408(Math.min(Math.max(progress, 0.0f), 1.0f));
    }
}

