/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.warp.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.warp.WarpModule;
import me.alexdevs.solstice.modules.warp.data.WarpServerData;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class WarpCommand
extends ModCommand<WarpModule> {
    public WarpCommand(WarpModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("warp");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(true))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            WarpServerData serverData = Solstice.serverData.getData(WarpServerData.class);
            Stream<String> warps = serverData.warps.keySet().stream().filter(serverPosition -> ((WarpModule)this.module).canUseWarp(player, (String)serverPosition)).sorted();
            return class_2172.method_9264(warps, (SuggestionsBuilder)builder);
        }).executes(context -> this.execute((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"))));
    }

    private int execute(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        WarpServerData serverDate = Solstice.serverData.getData(WarpServerData.class);
        ConcurrentHashMap<String, ServerLocation> warps = serverDate.warps;
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        Map<String, class_2561> placeholders = Map.of("warp", class_2561.method_30163((String)name));
        if (!warps.containsKey(name)) {
            ((class_2168)context.getSource()).method_9226(() -> ((WarpModule)this.module).locale().get("warpNotFound", playerContext, placeholders), false);
            return 0;
        }
        if (!((WarpModule)this.module).canUseWarp(player, name)) {
            ((class_2168)context.getSource()).method_9226(() -> ((WarpModule)this.module).locale().get("noPermission", playerContext, placeholders), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> ((WarpModule)this.module).locale().get("teleporting", playerContext, placeholders), false);
        ServerLocation warpPosition = warps.get(name);
        warpPosition.teleport(player);
        return 1;
    }
}

