package me.alexdevs.solstice.api;

import com.google.gson.annotations.Expose;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.modules.back.BackModule;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;

import java.util.Objects;

@ConfigSerializable
public class ServerPosition {
    @Expose
    public double x;
    @Expose
    public double y;
    @Expose
    public double z;
    @Expose
    public float yaw;
    @Expose
    public float pitch;
    @Expose
    public String world;

    public ServerPosition() {

    }

    public ServerPosition(double x, double y, double z, float yaw, float pitch, class_3218 world) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.world = world.method_27983().method_29177().toString();
    }

    public ServerPosition(class_3222 player) {
        this.x = player.method_23317();
        this.y = player.method_23318();
        this.z = player.method_23321();
        this.yaw = player.method_36454();
        this.pitch = player.method_36455();
        this.world = player.method_51469().method_27983().method_29177().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        ServerPosition that = (ServerPosition) o;
        return Double.compare(x, that.x) == 0 && Double.compare(y, that.y) == 0 && Double.compare(z, that.z) == 0 && Float.compare(yaw, that.yaw) == 0 && Float.compare(pitch, that.pitch) == 0 && Objects.equals(world, that.world);
    }

    @Override
    public int hashCode() {
        return Objects.hash(x, y, z, yaw, pitch, world);
    }

    public void teleport(class_3222 player, boolean setBackPosition) {
        if (setBackPosition) {
            var currentPosition = new ServerPosition(player);
            Solstice.modules.getModule(BackModule.class).lastPlayerPositions.put(player.method_5667(), currentPosition);
        }

        var serverWorld = getWorld(player.method_5682());

        player.method_18799(player.method_18798().method_18805(1f, 0f, 1f));
        player.method_24830(true);

        player.method_14251(serverWorld, this.x, this.y, this.z, this.yaw, this.pitch);

        // There is a bug (presumably in Fabric's api) that causes experience level to be set to 0 when teleporting between dimensions/worlds.
        // Therefore, this will update the experience client side as a temporary solution.
        player.method_7255(0);
    }

    public void teleport(class_3222 player) {
        teleport(player, true);
    }

    public class_5321<class_1937> getWorldKey() {
        return class_5321.method_29179(class_7924.field_41223, class_2960.method_60654(this.world));
    }

    public class_3218 getWorld(MinecraftServer server) {
        return server.method_3847(getWorldKey());
    }

    public class_2338 getBlockPos() {
        return class_2338.method_49637(this.x, this.y, this.z);
    }
}
