package me.alexdevs.solstice.api.events;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class PlayerActivityEvents {

    public static final Event<PlayerActivityEvents.Afk> AFK = EventFactory.createArrayBacked(PlayerActivityEvents.Afk.class, callbacks -> (handler, server) -> {
        for (PlayerActivityEvents.Afk callback : callbacks) {
            callback.onAfk(handler, server);
        }
    });

    public static final Event<PlayerActivityEvents.AfkReturn> AFK_RETURN = EventFactory.createArrayBacked(PlayerActivityEvents.AfkReturn.class, callbacks -> (handler, server) -> {
        for (PlayerActivityEvents.AfkReturn callback : callbacks) {
            callback.onAfkReturn(handler, server);
        }
    });

    @FunctionalInterface
    public interface Afk {
        void onAfk(class_3222 player, MinecraftServer server);
    }

    @FunctionalInterface
    public interface AfkReturn {
        void onAfkReturn(class_3222 player, MinecraftServer server);
    }
}
