package me.alexdevs.solstice.api.module;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;
import java.util.List;
import java.util.function.Predicate;

public abstract class ModCommand<T extends ModuleBase> {
    protected final T module;
    protected CommandDispatcher<class_2168> dispatcher;
    protected class_7157 commandRegistry;
    protected class_2170.class_5364 environment;

    public ModCommand(T module) {
        this.commandRegistry = null;
        this.environment = null;
        this.dispatcher = null;

        this.module = module;
    }

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistry, class_2170.class_5364 environment) {
        this.dispatcher = dispatcher;
        this.commandRegistry = commandRegistry;
        this.environment = environment;

        for (var name : getNames()) {
            registerCommand(command(name));
        }
    }

    public LiteralCommandNode<class_2168> registerCommand(LiteralArgumentBuilder<class_2168> command) {
        return dispatcher.register(command);
    }

    public String getName() {
        return getNames().stream().findFirst().orElseGet(() -> this.getClass().getSimpleName().toLowerCase());
    }

    public String getPermissionNode() {
        var node = module.getPermissionNode("base");
        Debug.commandDebugList.add(new Debug.CommandDebug(module.id, getName(), getNames(), node));
        return node;
    }

    public String getPermissionNode(String subNode) {
        var node = module.getPermissionNode(subNode);
        Debug.commandDebugList.add(new Debug.CommandDebug(module.id, getName(), getNames(), node));
        return node;
    }

    public Predicate<class_2168> require() {
        return Permissions.require(getPermissionNode());
    }

    public Predicate<class_2168> require(int defaultRequiredLevel) {
        return Permissions.require(getPermissionNode(), defaultRequiredLevel);
    }

    public Predicate<class_2168> require(boolean defaultValue) {
        return Permissions.require(getPermissionNode(), defaultValue);
    }

    public Predicate<class_2168> require(String subNode) {
        return Permissions.require(getPermissionNode(subNode));
    }

    public Predicate<class_2168> require(String subNode, int defaultRequiredLevel) {
        return Permissions.require(getPermissionNode(subNode), defaultRequiredLevel);
    }

    public Predicate<class_2168> require(String subNode, boolean defaultValue) {
        return Permissions.require(getPermissionNode(subNode), defaultValue);
    }

    /**
     * Define the name and aliases of the command. First value is the name, next values are aliases.
     *
     * @return List of names
     */
    public abstract List<String> getNames();

    /**
     * Generate the command node, this method gets called for every name.
     *
     * @param name Command name
     * @return Command node
     */
    public abstract LiteralArgumentBuilder<class_2168> command(String name);
}
