package me.alexdevs.solstice.api.text;

import eu.pb4.placeholders.api.TextParserUtils;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.TextParserV1;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.modules.core.CoreModule;
import me.alexdevs.solstice.modules.styling.StylingModule;
import me.alexdevs.solstice.modules.styling.data.StylingConfig;
import me.alexdevs.solstice.api.text.parser.MarkdownParser;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7471;
import java.util.Map;

public class Components {
    public static class_2561 button(class_2561 label, class_2561 hoverText, String command, boolean suggest) {
        var locale = Solstice.localeManager.getLocale(CoreModule.ID);
        var format = suggest ? locale.raw("~buttonSuggest") : locale.raw("~button");
        var placeholders = Map.of(
                "label", label,
                "hoverText", hoverText,
                "command", class_2561.method_30163(command)
        );

        var text = TextParserUtils.formatText(format);
        return Format.parse(text, placeholders);
    }

    public static class_2561 button(String label, String hoverText, String command) {

        return button(
                Format.parse(label),
                Format.parse(hoverText),
                command,
                false
        );
    }

    public static class_2561 buttonSuggest(String label, String hoverText, String command) {

        return button(
                Format.parse(label),
                Format.parse(hoverText),
                command,
                true
        );
    }

    public static class_2561 chat(class_7471 message, class_3222 player) {
        var allowAdvancedChatFormat = Permissions.check(player, StylingModule.ADVANCED_CHAT_FORMATTING_PERMISSION);

        return chat(message.method_44862(), allowAdvancedChatFormat);
    }

    public static class_2561 chat(String message, class_3222 player) {
        var allowAdvancedChatFormat = Permissions.check(player, StylingModule.ADVANCED_CHAT_FORMATTING_PERMISSION);

        return chat(message, allowAdvancedChatFormat);
    }

    public static class_2561 chat(String message, boolean allowAdvancedChatFormat) {
        var config = Solstice.configManager.getData(StylingConfig.class);
        var enableMarkdown = config.enableMarkdown;

        for (var repl : config.replacements.entrySet()) {
            message = message.replace(repl.getKey(), repl.getValue());
        }

        if (!allowAdvancedChatFormat && !enableMarkdown) {
            return class_2561.method_30163(message);
        }

        NodeParser parser;
        if (allowAdvancedChatFormat) {
            parser = NodeParser.merge(TextParserV1.DEFAULT, MarkdownParser.defaultParser);
        } else {
            parser = MarkdownParser.defaultParser;
        }

        return parser.parseNode(message).toText();
    }

    public static class_2561 chat(String message, class_2168 source) {
        if (source.method_43737())
            return chat(message, source.method_44023());
        return chat(message, true);
    }
}
