package me.alexdevs.solstice.api.text;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.TextParserUtils;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.PatternPlaceholderParser;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_2561;

public class Format {
    public static final Pattern PLACEHOLDER_PATTERN = PatternPlaceholderParser.PREDEFINED_PLACEHOLDER_PATTERN;

    public static class_2561 parse(String text) {
        return TextParserUtils.formatText(text);
    }

    public static class_2561 parse(TextNode textNode, PlaceholderContext context, Map<String, class_2561> placeholders) {
        var predefinedNode = Placeholders.parseNodes(textNode, PLACEHOLDER_PATTERN, placeholders);
        return Placeholders.parseText(predefinedNode, context);
    }

    public static class_2561 parse(class_2561 text, PlaceholderContext context, Map<String, class_2561> placeholders) {
        return parse(TextNode.convert(text), context, placeholders);
    }

    public static class_2561 parse(String text, PlaceholderContext context, Map<String, class_2561> placeholders) {
        return parse(parse(text), context, placeholders);
    }

    public static class_2561 parse(String text, PlaceholderContext context) {
        return parse(parse(text), context, Map.of());
    }

    public static class_2561 parse(String text, Map<String, class_2561> placeholders) {
        return Placeholders.parseText(parse(text), PLACEHOLDER_PATTERN, placeholders);
    }

    public static class_2561 parse(class_2561 text, Map<String, class_2561> placeholders) {
        return Placeholders.parseText(TextNode.convert(text), PLACEHOLDER_PATTERN, placeholders);
    }
}
