package me.alexdevs.solstice.api.text.parser;

import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ClickActionNode;
import eu.pb4.placeholders.api.node.parent.FormattingNode;
import eu.pb4.placeholders.api.node.parent.HoverNode;
import me.alexdevs.solstice.modules.core.CoreModule;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import me.alexdevs.solstice.api.text.Format;
import java.util.Map;

public class MarkdownComponentParser {
    public static TextNode spoilerFormatting(TextNode[] textNodes) {
        var text = TextNode.asSingle(textNodes);
        return new HoverNode<>(
                TextNode.array(
                        new FormattingNode(TextNode.array(TextNode.of("\u258C".repeat(text.toText().getString().length()))), class_124.field_1063)
                ),
                HoverNode.Action.TEXT, text);
    }

    public static TextNode quoteFormatting(TextNode[] textNodes) {
        return new ClickActionNode(
                TextNode.array(
                        new HoverNode<>(
                                TextNode.array(new FormattingNode(textNodes, class_124.field_1080)),
                                HoverNode.Action.TEXT, TextNode.of("Click to copy"))
                ),
                class_2558.class_2559.field_21462, TextNode.asSingle(textNodes)
        );
    }

    public static TextNode urlFormatting(TextNode[] textNodes, TextNode url) {
        var config = CoreModule.getConfig();
        var placeholders = Map.of(
                "label", TextNode.wrap(textNodes).toText(),
                "url", url.toText()
        );
        var text = Format.parse(config.link, placeholders);
        var hover = Format.parse(config.linkHover, placeholders);

        return new HoverNode<>(TextNode.array(
                new ClickActionNode(
                        TextNode.array(
                                TextNode.convert(text)
                        ),
                        class_2558.class_2559.field_11749, url)),
                HoverNode.Action.TEXT, TextNode.convert(hover)
        );
    }
}
