package me.alexdevs.solstice.core;

import me.alexdevs.solstice.Solstice;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3222;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CooldownManager {
    private final Map<UUID, Map<String, Integer>> cooldowns = new ConcurrentHashMap<>();

    public CooldownManager() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            var playerUuid = handler.method_32311().method_5667();
            cooldowns.computeIfAbsent(playerUuid, k -> new ConcurrentHashMap<>());
        });

        Solstice.scheduler.scheduleAtFixedRate(this::tickDown, 0, 1, TimeUnit.SECONDS);
    }

    private void tickDown() {
        for (var entry : cooldowns.entrySet()) {
            for (var cdEntry : entry.getValue().entrySet()) {
                var val = cdEntry.getValue() - 1;
                if (val <= 0) {
                    entry.getValue().remove(cdEntry.getKey());
                } else {
                    cdEntry.setValue(val);
                }
            }
        }
    }

    public boolean isExempt(class_3222 player, String node) {
        return Permissions.check(player, node + ".exempt.cooldown", 3);
    }

    public boolean onCooldown(class_3222 player, String node) {
        if (isExempt(player, node))
            return false;
        var uuid = player.method_5667();
        var cooldown = cooldowns.computeIfAbsent(uuid, k -> new ConcurrentHashMap<>());
        return cooldown.getOrDefault(node, 0) > 0;
    }

    /**
     * Check and start cooldown if the player is not on cooldown.
     * @param player Player
     * @param node Permission node
     * @param seconds Cooldown seconds
     * @return Whether to execute
     */
    public boolean trigger(class_3222 player, String node, int seconds) {
        if (onCooldown(player, node)) {
            return false;
        }

        if (isExempt(player, node)) {
            return true;
        }

        var uuid = player.method_5667();
        var cooldown = cooldowns.get(uuid);
        cooldown.put(node, seconds);

        return true;
    }

    public void clear(class_3222 player, String node) {
        var uuid = player.method_5667();
        var cooldown = cooldowns.get(uuid);
        cooldown.remove(node);
    }
}
