package me.alexdevs.solstice.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.modules.styling.CustomSentMessage;
import me.alexdevs.solstice.modules.ban.formatters.BanMessageFormatter;
import me.alexdevs.solstice.modules.styling.formatters.ConnectionActivityFormatter;
import net.minecraft.class_2535;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3336;
import net.minecraft.class_5250;
import net.minecraft.class_7471;
import net.minecraft.class_7604;
import net.minecraft.class_8792;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.net.SocketAddress;
import java.util.function.Predicate;

@Mixin(class_3324.class)
public abstract class PlayerManagerMixin {
    @Unique
    private class_3222 solstice$player = null;

    @Inject(method = "onPlayerConnect", at = @At("HEAD"))
    private void solstice$onJoin(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        solstice$player = player;
    }

    @Inject(method = "onPlayerConnect", at = @At("RETURN"))
    private void solstice$onJoinReturn(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        solstice$player = null;
    }

    @ModifyArg(method = "onPlayerConnect", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/PlayerManager;broadcast(Lnet/minecraft/text/Text;Z)V"))
    public class_2561 solstice$getPlayerJoinMessage(class_2561 message) {
        var ogText = (class_2588) message.method_10851();
        var args = ogText.method_11023();

        if (args.length == 1) {
            return ConnectionActivityFormatter.onJoin(solstice$player);
        } else {
            return ConnectionActivityFormatter.onJoinRenamed(solstice$player, (String) args[1]);
        }
    }

    @Inject(method = "checkCanJoin", at = @At(value = "RETURN", ordinal = 0), cancellable = true)
    public void solstice$formatBanMessage(SocketAddress address, GameProfile profile, CallbackInfoReturnable<class_2561> cir, @Local class_3336 bannedPlayerEntry, @Local class_5250 mutableText) {
        try {
            var reasonText = BanMessageFormatter.format(profile, bannedPlayerEntry);
            cir.setReturnValue(reasonText);
        } catch (Exception ex) {
            Solstice.LOGGER.error("Something went wrong while formatting the ban message", ex);

            // Ensure the original text message is returned to avoid exploits and bypass the ban
            cir.setReturnValue(mutableText);
        }
    }

    @Redirect(
            method = "broadcast(Lnet/minecraft/network/message/SignedMessage;Ljava/util/function/Predicate;Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/network/message/MessageType$Parameters;)V",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/network/message/SentMessage;of(Lnet/minecraft/network/message/SignedMessage;)Lnet/minecraft/network/message/SentMessage;")
    )
    private class_7604 solstice$broadcast(class_7471 sentMessagePar, class_7471 message, Predicate<class_3222> shouldSendFiltered, @Nullable class_3222 sender, class_2556.class_7602 params) {
        return CustomSentMessage.of(message, sender);
    }
}
