package me.alexdevs.solstice.mixin;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.modules.styling.formatters.ConnectionActivityFormatter;
import me.alexdevs.solstice.modules.tablist.data.TabListConfig;
import net.minecraft.class_2561;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.EnumSet;
import java.util.List;

@Mixin(class_3244.class)
public abstract class ServerPlayNetworkHandlerMixin {
    @Shadow
    public class_3222 player;

    @Inject(method = "tick", at = @At("TAIL"))
    private void solstice$updatePlayerList(CallbackInfo ci) {
        if (Solstice.configManager.getData(TabListConfig.class).enable) {
            var packet = new class_2703(EnumSet.of(class_2703.class_5893.field_29139, class_2703.class_5893.field_40700), List.of(this.player));
            this.player.method_5682().method_3760().method_14581(packet);
        }
    }

    @ModifyArg(method = "cleanUp", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/PlayerManager;broadcast(Lnet/minecraft/text/Text;Z)V"))
    private class_2561 solstice$getPlayerLeaveMessage(class_2561 message) {
        return ConnectionActivityFormatter.onLeave(this.player);
    }
}
