package me.alexdevs.solstice.mixin;

import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerPosition;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.modules.back.BackModule;
import me.alexdevs.solstice.modules.spawn.SpawnModule;
import me.alexdevs.solstice.modules.styling.formatters.DeathFormatter;
import me.alexdevs.solstice.modules.tablist.data.TabListConfig;
import net.minecraft.class_1283;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Set;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin {
    @Shadow
    @Final
    public MinecraftServer server;

    @Inject(method = "getPlayerListName", at = @At("HEAD"), cancellable = true)
    private void solstice$customizePlayerListName(CallbackInfoReturnable<class_2561> callback) {
        if (Solstice.configManager.getData(TabListConfig.class).enable) {
            var player = (class_3222) (Object) this;
            var playerContext = PlaceholderContext.of(player);
            var text = Format.parse(Solstice.configManager.getData(TabListConfig.class).playerTabName, playerContext);
            callback.setReturnValue(text);
        }
    }

    @Redirect(method = "onDeath", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/damage/DamageTracker;getDeathMessage()Lnet/minecraft/text/Text;"))
    private class_2561 solstice$getDeathMessage(class_1283 instance) {
        var player = (class_3222) (Object) this;
        return DeathFormatter.onDeath(player, instance);
    }

    @Inject(method = "teleport(Lnet/minecraft/server/world/ServerWorld;DDDLjava/util/Set;FF)Z", at = @At("HEAD"))
    public void solstice$requestTeleport(class_3218 world, double destX, double destY, double destZ, Set<class_2709> flags, float yaw, float pitch, CallbackInfoReturnable<Boolean> cir) {
        var player = (class_3222) (Object) this;
        Solstice.modules.getModule(BackModule.class).lastPlayerPositions.put(player.method_5667(), new ServerPosition(player));
    }

    @Inject(method = "getSpawnPointPosition", at = @At("RETURN"), cancellable = true)
    public void solstice$overrideSpawnPos(CallbackInfoReturnable<class_2338> cir) {
        var spawnModule = Solstice.modules.getModule(SpawnModule.class);
        var config = spawnModule.getConfig();
        if (config.globalSpawn.onRespawn) {
            var pos = spawnModule.getGlobalSpawnPosition().getBlockPos();
            cir.setReturnValue(pos);
        }
    }

    @Inject(method = "getSpawnPointDimension", at = @At("RETURN"), cancellable = true)
    public void solstice$overrideSpawnDimension(CallbackInfoReturnable<class_5321<class_1937>> cir) {
        var spawnModule = Solstice.modules.getModule(SpawnModule.class);
        var config = spawnModule.getConfig();
        if (config.globalSpawn.onRespawn) {
            cir.setReturnValue(spawnModule.getGlobalSpawnWorld().method_27983());
        }
    }

    @Inject(method = "getRespawnTarget", at = @At("RETURN"), cancellable = true)
    public void solstice$overrideRespawnTarget(boolean alive, class_5454.class_9823 postDimensionTransition, CallbackInfoReturnable<class_5454> cir) {
        var spawnModule = Solstice.modules.getModule(SpawnModule.class);
        var config = spawnModule.getConfig();
        if (config.globalSpawn.onRespawn) {
            var spawn = spawnModule.getGlobalSpawnPosition();

            var world = spawn.getWorld(this.server);
            var pos = new class_243(
                    spawn.x,
                    spawn.y,
                    spawn.z
            );

            cir.setReturnValue(new class_5454(
                    world,
                    pos,
                    class_243.field_1353,
                    spawn.yaw,
                    spawn.pitch,
                    false,
                    class_5454.field_52245
            ));
        }
    }
}
