package me.alexdevs.solstice.mixin;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.modules.sign.SignModule;
import net.minecraft.class_1657;
import net.minecraft.class_2625;
import net.minecraft.class_5837;
import net.minecraft.class_8242;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;

@Mixin(class_2625.class)
public abstract class SignBlockEntityMixin {

    @Inject(method = "getTextWithMessages", at = @At("HEAD"), cancellable = true)
    private void getTextWithMessages(class_1657 player, List<class_5837> messages, class_8242 text, CallbackInfoReturnable<class_8242> cir) {
        var formattableSignsModule = Solstice.modules.getModule(SignModule.class);
        if (formattableSignsModule.canFormatSign(player)) {
            try {
                text = SignModule.formatSign(messages, text);
                cir.setReturnValue(text);
            } catch (Exception e) {
                Solstice.LOGGER.error("Something went wrong while formatting a sign!", e);
            }
        }
    }
}
