package me.alexdevs.solstice.modules.afk.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.afk.AfkModule;
import net.minecraft.class_2168;
import java.util.List;

import static net.minecraft.class_2170.method_9247;

public class AfkCommand extends ModCommand<AfkModule> {
    public AfkCommand(AfkModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("afk");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(context -> {
                    var player = context.getSource().method_9207();

                    module.setPlayerAfk(player, true);

                    return 1;
                });
    }
}
