package me.alexdevs.solstice.modules.back.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.locale.Locale;
import me.alexdevs.solstice.modules.back.BackModule;
import net.minecraft.class_2168;
import java.util.List;

import static net.minecraft.class_2170.method_9247;

public class BackCommand extends ModCommand<BackModule> {
    private final Locale locale = Solstice.localeManager.getLocale(BackModule.ID);

    public BackCommand(BackModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("back");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var playerContext = PlaceholderContext.of(player);

                    var lastPosition = module.lastPlayerPositions.get(player.method_5667());
                    if (lastPosition == null) {
                        context.getSource().method_9226(() -> locale.get(
                                "noPosition",
                                playerContext
                        ), false);
                        return 1;
                    }

                    context.getSource().method_9226(() -> locale.get(
                            "teleporting",
                            playerContext
                    ), false);
                    lastPosition.teleport(player);

                    return 1;
                });
    }
}
