package me.alexdevs.solstice.modules.broadcast.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.broadcast.BroadcastModule;
import me.alexdevs.solstice.modules.broadcast.data.BroadcastConfig;
import net.minecraft.class_2168;
import me.alexdevs.solstice.api.text.Format;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class BroadcastCommand extends ModCommand<BroadcastModule> {

    public BroadcastCommand(BroadcastModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("broadcast", "bc");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .then(method_9244("message", StringArgumentType.greedyString())
                        .executes(context -> {
                            var config = Solstice.configManager.getData(BroadcastConfig.class);

                            var message = StringArgumentType.getString(context, "message");
                            var serverContext = PlaceholderContext.of(context.getSource().method_9211());

                            var placeholders = Map.of(
                                    "message", Format.parse(message, serverContext)
                            );

                            Solstice.getInstance().broadcast(Format.parse(config.format, placeholders));

                            return 1;
                        }));

    }
}
