package me.alexdevs.solstice.modules.commandSpy;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.commandSpy.data.CommandSpyConfig;
import me.alexdevs.solstice.modules.commandSpy.data.CommandSpyLocale;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2561;
import java.util.Map;

public class CommandSpyModule extends ModuleBase {
    public static final String ID = "commandspy";

    public CommandSpyModule() {
        super(ID);

        Solstice.configManager.registerData(ID, CommandSpyConfig.class, CommandSpyConfig::new);
        Solstice.localeManager.registerModule(ID, CommandSpyLocale.MODULE);

        SolsticeEvents.PLAYER_COMMAND.register((source, command) -> {
            var parts = command.split("\\s");
            if (parts.length >= 1) {
                var cmd = parts[0];
                if (isIgnored(cmd)) {
                    return;
                }
            }

            var players = source.method_5682().method_3760().method_14571();
            var placeholders = Map.of("player", class_2561.method_30163(source.method_7334().getName()), "command", class_2561.method_30163(command));
            var message = locale().get("spyFormat", placeholders);
            for (var player : players) {
                var commandSpyEnabled = Permissions.check(player, this.getPermissionNode("base"));

                if (commandSpyEnabled && !player.method_5667().equals(source.method_5667())) {
                    player.method_7353(message, false);
                }
            }
        });
    }

    public boolean isIgnored(String command) {
        return Solstice.configManager.getData(CommandSpyConfig.class).ignoredCommands.contains(command);
    }
}
