package me.alexdevs.solstice.modules.core.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.Debug;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.core.CoreModule;
import me.alexdevs.solstice.modules.customName.CustomNameModule;
import me.alexdevs.solstice.api.text.Format;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9247;

public class SolsticeCommand extends ModCommand<CoreModule> {
    public SolsticeCommand(CoreModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("solstice", "sol");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(context -> {
                    var modContainer = FabricLoader.getInstance().getModContainer(Solstice.MOD_ID).orElse(null);
                    if (modContainer == null) {
                        context.getSource().method_9226(() -> class_2561.method_30163("Could not find self in mod list???"), false);
                        return 1;
                    }

                    var metadata = modContainer.getMetadata();
                    var placeholders = Map.of(
                            "name", class_2561.method_30163(metadata.getName()),
                            "version", class_2561.method_30163(metadata.getVersion().getFriendlyString())
                    );

                    var text = Format.parse(
                            "<gold>${name} v${version}</gold>",
                            placeholders);
                    context.getSource().method_9226(() -> text, false);

                    return 1;
                })
                .then(method_9247("reload")
                        .requires(require("reload", 3))
                        .executes(context -> {
                            try {
                                Solstice.configManager.loadData(true);
                                Solstice.localeManager.reload();

                                Solstice.modules.getModule(CustomNameModule.class).refreshNames();
                            } catch (Exception e) {
                                Solstice.LOGGER.error("Failed to reload Solstice", e);
                                context.getSource().method_9226(() -> class_2561.method_30163("Failed to load Solstice config. Check console for more info."), true);
                                return 1;
                            }

                            SolsticeEvents.RELOAD.invoker().onReload(Solstice.getInstance());

                            context.getSource().method_9226(() -> class_2561.method_30163("Reloaded Solstice config"), true);

                            return 1;
                        }))
                .then(method_9247("debug")
                        .requires(require("debug", 4))
                        .then(method_9247("gen-command-list")
                                .executes(context -> {
                                    var builder = new StringBuilder();

                                    var list = new ArrayList<>(Debug.commandDebugList);

                                    list.sort(Comparator.comparing(Debug.CommandDebug::module));

                                    builder.append(String.format("| %s | %s | %s | %s |\n", "Module", "Command", "Aliases", "Permission"));
                                    builder.append("|---|---|---|---|\n");
                                    for (var command : list) {
                                        builder.append(String.format("| %s | %s | %s | %s |\n", command.module(), command.command(), String.join(" ", command.commands()), command.permission()));
                                    }

                                    var output = builder.toString();

                                    var file = FabricLoader.getInstance().getGameDir().resolve("solstice-commands.md").toFile();
                                    try (var fw = new FileWriter(file)) {
                                        fw.write(output);
                                    } catch (IOException e) {
                                        throw new SimpleCommandExceptionType(class_2561.method_30163(e.getMessage())).create();
                                    }

                                    context.getSource().method_9226(() -> class_2561.method_30163("Generated 'solstice-commands.md'"), true);

                                    return 1;
                                }))
                );
    }
}
