package me.alexdevs.solstice.modules.customName;

import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.integrations.LuckPermsIntegration;
import me.alexdevs.solstice.modules.customName.commands.NicknameCommand;
import me.alexdevs.solstice.modules.customName.data.CustomNameConfig;
import me.alexdevs.solstice.modules.customName.data.CustomNamePlayerData;
import me.alexdevs.solstice.api.text.Format;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class CustomNameModule extends ModuleBase {
    public static final String ID = "customname";

    private final ConcurrentHashMap<UUID, String> namesCache = new ConcurrentHashMap<>();

    public CustomNameModule() {
        super(ID);

        Solstice.configManager.registerData(ID, CustomNameConfig.class, CustomNameConfig::new);
        Solstice.playerData.registerData(ID, CustomNamePlayerData.class, CustomNamePlayerData::new);

        commands.add(new NicknameCommand(this));

        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> refreshNames());
        ServerPlayConnectionEvents.JOIN.register((handler, packetSender, server) -> refreshNames());
    }

    public void refreshNames() {
        namesCache.clear();

        for (var player : Solstice.server.method_3760().method_14571()) {
            refreshName(player);
        }
    }

    public void refreshName(class_3222 player) {
        namesCache.put(player.method_5667(), fetchUsernameFormat(player));
    }

    public String fetchUsernameFormat(class_3222 player) {
        var formats = Solstice.configManager.getData(CustomNameConfig.class).nameFormats;

        String format = null;
        for (var f : formats) {
            if (Permissions.check(player, "group." + f.group())) {
                format = f.format();
                break;
            }
        }

        var isOperator = player.method_5682().method_3760().method_14569(player.method_7334());

        if (format == null) {
            format = "${username}";

            for (var f : formats) {
                if (isOperator && f.group().equals("operator")) {
                    format = f.format();
                    break;
                }
                if (f.group().equals("default")) {
                    format = f.format();
                    break;
                }
            }
        }

        return format;
    }

    public class_5250 getNameForPlayer(class_3222 player) {
        var format = namesCache.get(player.method_5667());
        if (format == null) {
            // to avoid stack overflow we push the plain text version of the player
            namesCache.put(player.method_5667(), player.method_7334().getName());

            format = fetchUsernameFormat(player);
            namesCache.put(player.method_5667(), format);
        }

        var playerData = Solstice.playerData.get(player).getData(CustomNamePlayerData.class);

        var name = playerData.nickname == null ? player.method_7334().getName() : playerData.nickname;

        var prefix = LuckPermsIntegration.getPrefix(player);
        var suffix = LuckPermsIntegration.getSuffix(player);
        if (prefix == null)
            prefix = "";
        if (suffix == null)
            suffix = "";

        Map<String, String> placeholders = Map.of(
                "name", name,
                "prefix", prefix,
                "suffix", suffix
        );

        var pattern = Format.PLACEHOLDER_PATTERN;
        var output = format;
        var matcher = pattern.matcher(format);
        while (matcher.find()) {
            var chunk = matcher.group();
            var key = matcher.group("id");
            output = output.replace(chunk, placeholders.getOrDefault(key, ""));
        }

        var playerContext = PlaceholderContext.of(player);
        return Format.parse(output, playerContext).method_27661();
    }

    public void setCustomName(class_3222 player, String name) {
        var playerData = Solstice.playerData.get(player).getData(CustomNamePlayerData.class);
        playerData.nickname = name;
        refreshName(player);
    }

    public void clearCustomName(class_3222 player) {
        var playerData = Solstice.playerData.get(player).getData(CustomNamePlayerData.class);
        playerData.nickname = null;
        refreshName(player);
    }
}
