package me.alexdevs.solstice.modules.customName.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.customName.CustomNameModule;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class NicknameCommand extends ModCommand<CustomNameModule> {

    public NicknameCommand(CustomNameModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("nickname", "nick");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .then(method_9247("clear")
                        .executes(context -> executeClear(context, null))
                )
                .then(method_9244("nickname", StringArgumentType.string())
                        .executes(context -> execute(context, StringArgumentType.getString(context, "nickname"), null))
                )
                .then(method_9244("player", class_2186.method_9305())
                        .requires(require("others", 2))
                        .then(method_9247("clear")
                                .executes(context -> executeClear(context, class_2186.method_9315(context, "player")))
                        )
                        .then(method_9244("nickname", StringArgumentType.string())
                                .executes(context -> execute(context, StringArgumentType.getString(context, "nickname"), class_2186.method_9315(context, "player")))
                        )
                );
    }

    private int execute(CommandContext<class_2168> context, String nickname, @Nullable class_3222 player) throws CommandSyntaxException {
        if (player == null) {
            player = context.getSource().method_9207();
        }

        module.setCustomName(player, nickname);

        var name = player.method_7334().getName();
        context.getSource().method_9226(() -> class_2561.method_43470(String.format("Changed %s's nickname", name)), true);

        return 1;
    }

    private int executeClear(CommandContext<class_2168> context, @Nullable class_3222 player) throws CommandSyntaxException {
        if (player == null) {
            player = context.getSource().method_9207();
        }

        module.clearCustomName(player);

        var name = player.method_7334().getName();
        context.getSource().method_9226(() -> class_2561.method_43470(String.format("Cleared %s's nickname", name)), true);

        return 1;
    }
}
