package me.alexdevs.solstice.modules.enderchest.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.enderchest.EnderChestModule;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1707;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_747;
import org.jetbrains.annotations.Nullable;

import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class EnderChestCommand extends ModCommand<EnderChestModule> {
    public EnderChestCommand(EnderChestModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("enderchest", "ec");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .executes(context -> execute(context, null))
                .then(method_9244("player", class_2186.method_9305())
                        .requires(require("others", 2))
                        .executes(context -> execute(context, class_2186.method_9315(context, "player"))));
    }

    private int execute(CommandContext<class_2168> context, @Nullable class_3222 target) throws CommandSyntaxException {
        var source = context.getSource();
        var player = source.method_9207();

        if (target != null) {
            if (Permissions.check(target, getPermissionNode("exempt"))) {
                source.method_9213(class_2561.method_30163("You cannot open this Ender Chest because the player is exempt."));
                return 0;
            }
        } else {
            target = player;
        }

        var enderChestInventory = target.method_7274();
        player.method_17355(
                new class_747((syncId, inventory, playerx) ->
                        class_1707.method_19245(syncId, inventory, enderChestInventory),
                        class_2561.method_43471("container.enderchest")));
        player.method_7281(class_3468.field_15424);

        return 1;
    }
}
