package me.alexdevs.solstice.modules.feed.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.feed.FeedModule;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class FeedCommand extends ModCommand<FeedModule> {
    private static final int MAX_FOOD_LEVEL = 20;

    public FeedCommand(FeedModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("feed");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .executes(context -> execute(context, null))
                .then(method_9244("targets", class_2186.method_9308())
                        .requires(require("others", 2))
                        .executes(context -> execute(context, class_2186.method_9312(context, "targets"))));
    }

    private int execute(CommandContext<class_2168> context, @Nullable Collection<class_3222> targets) throws CommandSyntaxException {
        if (targets == null) {
            var player = context.getSource().method_9207();
            feed(context, player);
            return 1;
        } else {
            for (var target : targets) {
                feed(context, target);
            }

            return targets.size();
        }
    }

    private void feed(CommandContext<class_2168> context, class_3222 player) {
        player.method_7344().method_7580(MAX_FOOD_LEVEL);
        player.method_7344().method_7581(MAX_FOOD_LEVEL);
        context.getSource().method_9226(() -> class_2561.method_43470("Fed ").method_10852(player.method_5476()), true);
    }
}
