package me.alexdevs.solstice.modules.home.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.home.HomeModule;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class HomeCommand extends ModCommand<HomeModule> {
    public HomeCommand(HomeModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("home");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(context -> execute(context, "home"))
                .then(method_9244("name", StringArgumentType.word())
                        .suggests((context, builder) -> {
                            if (!context.getSource().method_43737())
                                return class_2172.method_9253(new String[]{}, builder);

                            var data = module.getData(context.getSource().method_44023().method_5667());

                            return class_2172.method_9264(data.homes.keySet().stream(), builder);
                        })
                        .executes(context -> execute(context, StringArgumentType.getString(context, "name"))));
    }

    private int execute(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var data = module.getData(player.method_5667());
        var playerContext = PlaceholderContext.of(player);

        var placeholders = Map.of(
                "home", class_2561.method_30163(name)
        );

        if (!data.homes.containsKey(name)) {
            context.getSource().method_9226(() ->
                    module.locale().get(
                            "homeNotFound",
                            playerContext,
                            placeholders
                    ), false);

            return 1;
        }

        context.getSource().method_9226(() ->
                module.locale().get(
                        "teleporting",
                        playerContext,
                        placeholders
                ), false);

        var homePosition = data.homes.get(name);
        homePosition.teleport(player);

        return 1;
    }

}
