package me.alexdevs.solstice.modules.home.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.home.HomeModule;
import net.minecraft.class_2168;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class HomesCommand extends ModCommand<HomeModule> {
    public HomesCommand(HomeModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("homes");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require( true))
                .executes(this::execute)
                .then(method_9244("player", class_2191.method_9329())
                        .requires(require("others", 2))
                        .executes(context -> executeOthers(context, class_2191.method_9330(context, "player"))));
    }

    private int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var data = module.getData(player.method_5667());
        var homeList = data.homes.keySet().stream().toList();
        var playerContext = PlaceholderContext.of(player);

        if (homeList.isEmpty()) {
            context.getSource().method_9226(() -> module.locale().get(
                    "noHomes",
                    playerContext
            ), false);
            return 1;
        }

        var listText = class_2561.method_43473();
        var comma = module.locale().get("homesComma");
        for (var i = 0; i < homeList.size(); i++) {
            if (i > 0) {
                listText = listText.method_10852(comma);
            }
            var placeholders = Map.of(
                    "home", class_2561.method_30163(homeList.get(i))
            );

            listText = listText.method_10852(module.locale().get(
                    "homesFormat",
                    playerContext,
                    placeholders
            ));
        }

        var placeholders = Map.of(
                "homeList", (class_2561) listText
        );
        context.getSource().method_9226(() -> module.locale().get(
                "homeList",
                playerContext,
                placeholders
        ), false);

        return homeList.size();
    }

    private int executeOthers(CommandContext<class_2168> context, Collection<GameProfile> profiles) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var playerContext = PlaceholderContext.of(player);

        if (profiles.size() > 1) {
            context.getSource().method_9226(() -> module.locale().get(
                    "~tooManyTargets",
                    playerContext
            ), false);
            return 0;
        }

        var profile = profiles.iterator().next();

        var data = module.getData(profile.getId());
        var homeList = data.homes.keySet().stream().toList();

        if (homeList.isEmpty()) {
            var placeholders = Map.of(
                    "owner", class_2561.method_30163(profile.getName())
            );
            context.getSource().method_9226(() -> module.locale().get(
                    "noHomesOther",
                    playerContext,
                    placeholders
            ), false);
            return 1;
        }

        var listText = class_2561.method_43473();
        var comma = module.locale().get("homesComma");
        for (var i = 0; i < homeList.size(); i++) {
            if (i > 0) {
                listText = listText.method_10852(comma);
            }
            var placeholders = Map.of(
                    "home", class_2561.method_30163(homeList.get(i)),
                    "owner", class_2561.method_30163(profile.getName())
            );

            listText = listText.method_10852(module.locale().get(
                    "homesFormatOther",
                    playerContext,
                    placeholders
            ));
        }

        var placeholders = Map.of(
                "homeList", listText,
                "owner", class_2561.method_30163(profile.getName())
        );
        context.getSource().method_9226(() -> module.locale().get(
                "homeListOther",
                playerContext,
                placeholders
        ), false);

        return homeList.size();
    }
}