package me.alexdevs.solstice.modules.home.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.ServerPosition;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.home.HomeModule;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import me.alexdevs.solstice.api.text.Components;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class SetHomeCommand extends ModCommand<HomeModule> {
    public SetHomeCommand(HomeModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("sethome");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(context -> execute(context,
                        "home",
                        false))
                .then(method_9244("name", StringArgumentType.word())
                        .executes(context -> execute(context,
                                StringArgumentType.getString(context, "name"),
                                false))
                        .then(method_9247("force")
                                .executes(context -> execute(context,
                                        StringArgumentType.getString(context, "name"),
                                        true))));

    }

    private int execute(CommandContext<class_2168> context, String name, boolean forced) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var data = module.getData(player.method_5667());
        var homes = data.homes;
        var playerContext = PlaceholderContext.of(player);

        var placeholders = Map.of(
                "home", class_2561.method_30163(name),
                "forceSetButton", Components.button(
                        module.locale().raw("forceSetLabel"),
                        module.locale().raw("forceSetHover"),
                        "/sethome " + name + " true"
                )
        );

        var exists = homes.containsKey(name);
        if (exists && !forced) {
            var text = module.locale().get(
                    "homeExists",
                    playerContext,
                    placeholders
            );

            context.getSource().method_9226(() -> text, false);

            return 1;
        }


        var maxHomes = module.getConfig().maxHomes;
        if (maxHomes >= 0 && homes.size() >= maxHomes && !exists) {
            context.getSource().method_9226(() -> module.locale().get(
                    "maxHomesReached",
                    playerContext,
                    placeholders
            ), false);
            return 1;
        }

        var homePosition = new ServerPosition(player);
        homes.put(name, homePosition);

        context.getSource().method_9226(() -> module.locale().get(
                "homeSetSuccess",
                playerContext,
                placeholders
        ), false);

        return 1;
    }
}
