package me.alexdevs.solstice.modules.info.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.module.Utils;
import me.alexdevs.solstice.modules.info.InfoModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class InfoCommand extends ModCommand<InfoModule> {
    public InfoCommand(InfoModule module) {
        super(module);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistry, class_2170.class_5364 environment) {
        // WorldEdit's /info -> /tool info
        Utils.removeCommands(dispatcher, "info");
        super.register(dispatcher, commandRegistry, environment);
    }

    @Override
    public List<String> getNames() {
        return List.of("info", "pages");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(context -> {

                    var source = context.getSource();
                    var pageList = module.enumerate();
                    var sourceContext = PlaceholderContext.of(source);

                    if (pageList.isEmpty()) {
                        context.getSource().method_9226(() -> module.locale.get(
                                "noPages",
                                sourceContext
                        ), false);
                        return 1;
                    }

                    var listText = class_2561.method_43473();
                    var comma = module.locale.get("pagesComma");
                    var list = pageList.stream().toList();
                    for (var i = 0; i < list.size(); i++) {
                        if (i > 0) {
                            listText = listText.method_10852(comma);
                        }
                        var placeholders = Map.of(
                                "page", class_2561.method_30163(list.get(i))
                        );

                        listText = listText.method_10852(module.locale.get(
                                "pagesFormat",
                                sourceContext,
                                placeholders
                        ));
                    }

                    var placeholders = Map.of(
                            "pageList", (class_2561) listText
                    );
                    context.getSource().method_9226(() -> module.locale.get(
                            "pageList",
                            sourceContext,
                            placeholders
                    ), false);

                    return 1;
                })
                .then(method_9244("page", StringArgumentType.word())
                        .suggests((context, builder) -> class_2172.method_9265(module.enumerate(), builder))
                        .executes(context -> {
                            var sourceContext = PlaceholderContext.of(context.getSource());
                            var page = module.getPage(StringArgumentType.getString(context, "page"), sourceContext);
                            context.getSource().method_9226(() -> page, false);
                            return 1;
                        }));

    }
}
