package me.alexdevs.solstice.modules.inventorySee.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.inventorySee.InventorySeeModule;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_9334;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class InventorySeeCommand extends ModCommand<InventorySeeModule> {
    public InventorySeeCommand(InventorySeeModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("invsee", "inventorysee");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .then(method_9244("player", class_2186.method_9305())
                        .executes(context -> {
                            var source = context.getSource();
                            var player = source.method_9207();
                            var target = class_2186.method_9315(context, "player");

                            if (Permissions.check(target, getPermissionNode() + ".exempt", 3)) {
                                source.method_9213(class_2561.method_30163("You cannot open this inventory because the player is exempt."));
                                return 0;
                            }

                            var targetInventory = player.method_31548();

                            var container = new SimpleGui(class_3917.field_18667, player, false);

                            for (var i = 0; i < targetInventory.method_5439(); i++) {
                                container.setSlotRedirect(i, new class_1735(targetInventory, i, 0, 0));
                            }

                            var barrier = new class_1799(class_1802.field_8077);
                            barrier.method_57379(class_9334.field_49631, class_2561.method_43470(""));
                            for (var i = targetInventory.method_5439(); i < container.getSize(); i++) {
                                container.setSlot(i, barrier);
                            }

                            container.setTitle(target.method_5476());

                            container.open();

                            return 1;
                        }));
    }
}
