package me.alexdevs.solstice.modules.kit.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.kit.KitModule;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class KitCommand extends ModCommand<KitModule> {
    public KitCommand(KitModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("kit");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(this::listKits)
                .then(method_9247("claim")
                        .then(method_9244("name", StringArgumentType.word())
                                .suggests(this::suggestKitList)
                                .executes(this::claimKit))
                )
                .then(method_9247("create")
                        .requires(require("set", 3))
                        .then(method_9244("name", StringArgumentType.word())
                                .executes(this::createKit))
                )
                .then(method_9247("delete")
                        .requires(require("set", 3))
                        .then(method_9244("name", StringArgumentType.word())
                                .suggests(this::suggestAllKits)
                                .executes(this::deleteKit))
                )
                .then(method_9247("edit")
                        .requires(require("set", 3))
                        .then(method_9244("name", StringArgumentType.word())
                                .suggests(this::suggestKitList)
                                .executes(this::editKit))
                )
                .then(method_9247("set")
                        .requires(require("set", 3))
                        .then(method_9244("name", StringArgumentType.word())
                                .suggests(this::suggestAllKits)
                                .then(method_9247("first-join"))
                                .then(method_9247("cooldown"))
                                .then(method_9247("one-time"))
                        )
                )
                .then(method_9244("name", StringArgumentType.word())
                        .suggests(this::suggestKitList)
                        .executes(this::claimKit));
    }

    private int listKits(CommandContext<class_2168> context) {
        return 1;
    }

    private int editKit(CommandContext<class_2168> context) {
        return 1;
    }

    private int claimKit(CommandContext<class_2168> context) {
        return 1;
    }

    private int deleteKit(CommandContext<class_2168> context) {
        return 1;
    }

    private int createKit(CommandContext<class_2168> context) {
        return 1;
    }

    private CompletableFuture<Suggestions> suggestAllKits(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        var kits = module.getKits().keySet();
        return class_2172.method_9265(kits, builder);
    }

    private CompletableFuture<Suggestions> suggestKitList(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        var kits = module.getKits().keySet();
        return class_2172.method_9265(kits, builder);
    }
}
