package me.alexdevs.solstice.modules.mute.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.mute.MuteModule;
import net.minecraft.class_2168;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class MuteCommand extends ModCommand<MuteModule> {
    public MuteCommand(MuteModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("mute");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .then(method_9244("targets", class_2191.method_9329())
                        .executes(context -> {
                            var targets = class_2191.method_9330(context, "targets");

                            var names = targets.stream().map(GameProfile::getName).toArray(String[]::new);

                            var muteModule = Solstice.modules.getModule(MuteModule.class);

                            targets.forEach(profile -> {
                                var playerData = muteModule.getPlayerData(profile.getId());
                                playerData.muted = true;
                            });

                            Solstice.playerData.saveAll();

                            context.getSource().method_9226(() -> class_2561.method_43470("Muted " + String.join(", ", names)), true);

                            return 1;
                        }));
    }
}
