package me.alexdevs.solstice.modules.rtp.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.rtp.RTPModule;
import me.alexdevs.solstice.modules.rtp.core.Locator;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9247;

public class RTPCommand extends ModCommand<RTPModule> {
    public RTPCommand(RTPModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("rtp");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var config = module.getConfig();

                    if(config.requireWorldPermission) {
                        var worldName = player.method_51469().method_27983().method_29177().toString();
                        if (!Permissions.check(context.getSource(), getPermissionNode("worlds." + worldName), 2)) {
                            context.getSource().method_9226(() -> module.locale().get("noWorldPermission", Map.of("world", class_2561.method_30163(worldName))), false);
                            return 0;
                        }
                    }

                    if (config.cooldown.enable) {
                        if (!Solstice.cooldown.trigger(player, module.getPermissionNode(), config.cooldown.cooldown)) {
                            context.getSource().method_9226(() -> module.locale().get("~cooldown"), false);
                            return 0;
                        }
                    }

                    final var server = context.getSource().method_9211();
                    final var uuid = player.method_5667();
                    var locator = module.createLocator(player);
                    locator.locate(result -> {
                        var newPlayer = server.method_3760().method_14602(uuid);
                        if (newPlayer == null) {
                            Solstice.LOGGER.info("RTP spot found, but player left.");
                            return;
                        }
                        if (result.position().isPresent() && result.type() == Locator.Result.Type.SUCCESS) {
                            player.method_43496(module.locale().get("success"));
                            result.position().get().teleport(player);
                        } else {
                            final var text = switch (result.type()) {
                                case TOO_MANY_ATTEMPTS -> module.locale().get("tooManyAttempts");
                                case TIMEOUT -> module.locale().get("timeout");
                                case UNSAFE -> module.locale().get("unsafe");
                                default -> class_2561.method_30163(result.type().toString());
                            };
                            player.method_43496(text);

                            if (config.cooldown.cancelOnFail) {
                                Solstice.cooldown.clear(player, module.getPermissionNode());
                            }
                        }
                    });

                    context.getSource().method_9226(() -> module.locale().get("searching"), false);

                    return 1;
                });
    }
}
