package me.alexdevs.solstice.modules.seen.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.ServerPosition;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.core.CoreModule;
import me.alexdevs.solstice.modules.seen.SeenModule;
import me.alexdevs.solstice.api.text.Format;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class SeenCommand extends ModCommand<SeenModule> {
    public SeenCommand(SeenModule module) {
        super(module);
    }

    public static String getPositionAsString(@Nullable ServerPosition pos) {
        if (pos == null)
            return "Unknown position";

        return String.format("%.01f %.01f %.01f, %s", pos.x, pos.y, pos.z, pos.world);
    }

    @Override
    public List<String> getNames() {
        return List.of("seen", "playerinfo");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .then(method_9244("player", StringArgumentType.word())
                        .executes(context -> {
                            var targetName = StringArgumentType.getString(context, "player");
                            var source = context.getSource();
                            source.method_9211().method_3793().method_37156(targetName).thenAcceptAsync((profile) -> {
                                if (profile.isEmpty()) {
                                    source.method_9226(() -> module.locale().get("playerNotFound"), false);
                                    return;
                                }
                                boolean extended;
                                if (context.getSource().method_43737()) {
                                    extended = Permissions.check(context.getSource().method_44023(), getPermissionNode("extended"), 2);
                                } else {
                                    extended = true;
                                }

                                var config = CoreModule.getConfig();

                                var dateFormatter = new SimpleDateFormat(config.dateTimeFormat);
                                var player = source.method_9211().method_3760().method_14602(profile.get().getId());
                                var playerData = CoreModule.getPlayerData(profile.get().getId());

                                ServerPosition location;
                                if (player == null) {
                                    location = playerData.logoffPosition;
                                } else {
                                    location = new ServerPosition(player);
                                }

                                Map<String, class_2561> map = Map.of(
                                        "username", class_2561.method_30163(profile.get().getName()),
                                        "uuid", class_2561.method_30163(profile.get().getId().toString()),
                                        "firstSeenDate", class_2561.method_30163(dateFormatter.format(playerData.firstJoinedDate)),
                                        "lastSeenDate", player != null ? class_2561.method_30163("online") : class_2561.method_30163(dateFormatter.format(playerData.lastSeenDate)),
                                        "ipAddress", class_2561.method_30163(playerData.ipAddress),
                                        "location", class_2561.method_30163(getPositionAsString(location))
                                );

                                var outputString = module.locale().raw("base");
                                if (extended) {
                                    outputString += "\n";
                                    outputString += module.locale().raw("extended");
                                }

                                final var finalOutput = outputString;
                                if (player != null) {
                                    source.method_9226(() -> Format.parse(finalOutput, PlaceholderContext.of(player), map), false);
                                } else {
                                    source.method_9226(() -> Format.parse(finalOutput, PlaceholderContext.of(source.method_9211()), map), false);
                                }
                            });

                            return 1;
                        }));
    }
}
