package me.alexdevs.solstice.modules.spawn;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerPosition;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.spawn.commands.FirstSpawnCommand;
import me.alexdevs.solstice.modules.spawn.commands.SetFirstSpawnCommand;
import me.alexdevs.solstice.modules.spawn.commands.SetSpawnCommand;
import me.alexdevs.solstice.modules.spawn.commands.SpawnCommand;
import me.alexdevs.solstice.modules.spawn.data.SpawnConfig;
import me.alexdevs.solstice.modules.spawn.data.SpawnLocale;
import me.alexdevs.solstice.modules.spawn.data.SpawnServerData;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class SpawnModule extends ModuleBase {
    public static final String ID = "spawn";

    @SuppressWarnings("deprecation")
    public SpawnModule() {
        super(ID);

        Solstice.localeManager.registerModule(ID, SpawnLocale.MODULE);
        Solstice.serverData.registerData(ID, SpawnServerData.class, SpawnServerData::new);
        Solstice.configManager.registerData(ID, SpawnConfig.class, SpawnConfig::new);

        commands.add(new SpawnCommand(this));
        commands.add(new SetSpawnCommand(this));
        commands.add(new FirstSpawnCommand(this));
        commands.add(new SetFirstSpawnCommand(this));

        SolsticeEvents.WELCOME.register((player, server) -> {
            var firstSpawn = getFirstSpawn();
            if (firstSpawn != null) {
                // Send next tick, twice, so it does not conflict with "on-login" spawn setting.
                Solstice.nextTick(() -> Solstice.nextTick(() -> firstSpawn.teleport(player)));
            }
        });

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            var config = getConfig();
            if (config.globalSpawn.onLogin) {
                Solstice.nextTick(() -> {
                    getGlobalSpawnPosition().teleport(handler.method_32311(), false);
                });
            }
        });

        SolsticeEvents.READY.register((instance, server) -> {
            var spawnData = getServerData();
            if (spawnData.spawn != null) {
                var legacy = spawnData.spawn;
                var world = legacy.getWorld(server);
                world.method_8554(new class_2338((int) legacy.x, (int) legacy.y, (int) legacy.z), legacy.yaw);
                spawnData.spawn = null;
            }
        });
    }

    @Deprecated
    public ServerPosition getSpawn() {
        var serverData = getServerData();
        var spawnPosition = serverData.spawn;
        if (spawnPosition == null) {
            var server = Solstice.server;
            var spawnPos = server.method_30002().method_43126();
            spawnPosition = new ServerPosition(spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260(), 0, 0, server.method_30002());
        }
        return spawnPosition;
    }

    public class_3218 getGlobalSpawnWorld() {
        var targetWorld = getConfig().globalSpawn.targetSpawnWorld;

        var key = class_5321.method_29179(class_7924.field_41223, class_2960.method_60654(targetWorld));
        return Solstice.server.method_3847(key);
    }

    public ServerPosition getGlobalSpawnPosition() {
        var world = getGlobalSpawnWorld();
        var worldSpawnPos = world.method_43126().method_46558();
        var worldSpawnRot = world.method_43127();
        return new ServerPosition(
                worldSpawnPos.method_10216(), worldSpawnPos.method_10214(), worldSpawnPos.method_10215(), worldSpawnRot, 0, world
        );
    }

    public ServerPosition getWorldSpawn(class_3218 world) {
        var spawnPos = world.method_43126().method_46558();
        var yaw = world.method_43127();
        return new ServerPosition(spawnPos.method_10216(), spawnPos.method_10214(), spawnPos.method_10215(), yaw, 0, world);
    }

    public SpawnConfig getConfig() {
        return Solstice.configManager.getData(SpawnConfig.class);
    }

    public SpawnServerData getServerData() {
        return Solstice.serverData.getData(SpawnServerData.class);
    }

    public void sendToSpawn(class_3222 player) {
        sendToSpawn(player, player.method_51469());
    }

    public void sendToSpawn(class_3222 player, class_3218 world) {
        var pos = getWorldSpawn(world);
        pos.teleport(player);
    }

    public @Nullable ServerPosition getFirstSpawn() {
        return Solstice.serverData.getData(SpawnServerData.class).firstSpawn;
    }
}
