package me.alexdevs.solstice.modules.spawn.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.ServerPosition;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.spawn.SpawnModule;
import net.minecraft.class_2168;
import java.util.List;

import static net.minecraft.class_2170.method_9247;

public class SetFirstSpawnCommand extends ModCommand<SpawnModule> {
    public SetFirstSpawnCommand(SpawnModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("setfirstspawn");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require("firstspawn.set", 2))
                .then(method_9247("delete")
                        .executes(this::executeDel))
                .executes(this::executeSet);
    }

    private int executeDel(CommandContext<class_2168> context) {
        var data = module.getServerData();
        data.firstSpawn = null;

        context.getSource().method_9226(() -> module.locale().get("firstSpawnDeleted"), true);

        return 1;
    }

    private int executeSet(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var data = module.getServerData();
        data.firstSpawn = new ServerPosition(player);

        context.getSource().method_9226(() -> module.locale().get("firstSpawnSet"), true);

        return 1;
    }
}
