package me.alexdevs.solstice.modules.styling.formatters;

import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.modules.styling.StylingModule;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7471;
import me.alexdevs.solstice.api.text.Components;
import me.alexdevs.solstice.api.text.Format;
import java.util.Map;

public class ChatFormatter {
    public static void sendChatMessage(class_3222 receiver, class_7471 message, class_2556.class_7602 params, class_3222 sender) {
        var text = getFormattedMessage(message, sender);

        receiver.method_43496(text);

//        var msgType = Solstice.server.getRegistryManager().get(RegistryKeys.MESSAGE_TYPE).getOrThrow(Solstice.CHAT_TYPE);
//        var newParams = new MessageType.Parameters(msgType, text, null);
//
//        receiver.networkHandler.sendProfilelessChatMessage(message.getContent(), newParams);
    }

    public static class_2561 getFormattedMessage(class_7471 message, class_3222 player) {
        class_2561 messageText = Components.chat(message, player);

        var config = Solstice.modules.getModule(StylingModule.class).getConfig();

        var playerContext = PlaceholderContext.of(player);
        return Format.parse(
                config.chatFormat,
                playerContext,
                Map.of(
                        "message", messageText
                )
        );
    }
}
