package me.alexdevs.solstice.modules.tablist;

import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.tablist.data.TabListConfig;
import me.alexdevs.solstice.api.text.Format;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2772;
import net.minecraft.server.MinecraftServer;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TabListModule extends ModuleBase {
    public static final String ID = "tablist";

    private MinecraftServer server;
    private ScheduledFuture<?> scheduledFuture = null;

    public TabListModule() {
        super(ID);

        Solstice.configManager.registerData(ID, TabListConfig.class, TabListConfig::new);

        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.server = server;
            schedule();
        });

        SolsticeEvents.RELOAD.register(instance -> {
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            schedule();
        });
    }

    private void schedule() {
        var config = Solstice.configManager.getData(TabListConfig.class);
        if (!config.enable)
            return;

        scheduledFuture = Solstice.scheduler.scheduleAtFixedRate(this::updateTab, 0, config.delay, TimeUnit.MILLISECONDS);
    }

    public void updateTab() {
        var config = Solstice.configManager.getData(TabListConfig.class);
        var period = Math.max(config.phasePeriod, 1);

        var phase = (Math.sin((server.method_3780() * Math.PI * 2) / period) + 1) / 2d;

        var placeholders = Map.of(
                "phase", class_2561.method_30163(String.valueOf(phase))
        );

        server.method_3760().method_14571().forEach(player -> {
            var playerContext = PlaceholderContext.of(player);
            var header = String.join("\n", config.header);
            var footer = String.join("\n", config.footer);
            player.field_13987.method_14364(new class_2772(
                    Format.parse(header, playerContext, placeholders),
                    Format.parse(footer, playerContext, placeholders)
            ));
        });
    }
}
