package me.alexdevs.solstice.modules.teleportOffline.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.core.data.CorePlayerData;
import me.alexdevs.solstice.modules.teleportOffline.TeleportOfflineModule;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class TeleportOfflineCommand extends ModCommand<TeleportOfflineModule> {
    public TeleportOfflineCommand(TeleportOfflineModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("tpoffline", "tpoff");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .then(method_9244("player", StringArgumentType.word())
                        .executes(context -> {
                            var source = context.getSource();
                            var player = source.method_9207();
                            var server = context.getSource().method_9211();

                            var targetName = StringArgumentType.getString(context, "player");

                            server.method_3793().method_37156(targetName).thenAcceptAsync(gameProfile -> {
                                if (gameProfile.isEmpty()) {
                                    source.method_9213(class_2561.method_30163("Could not find player"));
                                    return;
                                }

                                var targetData = Solstice.playerData.get(gameProfile.get()).getData(CorePlayerData.class);
                                if (targetData == null || targetData.logoffPosition == null) {
                                    source.method_9213(class_2561.method_30163("Could not find location of offline player"));
                                    return;
                                }

                                source.method_9226(() -> class_2561.method_43469("commands.teleport.success.entity.single", player.method_5476(), class_2561.method_30163(gameProfile.get().getName())), true);

                                targetData.logoffPosition.teleport(player, true);
                            });
                            return 1;
                        }));
    }
}
