package me.alexdevs.solstice.modules.teleportRequest.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerPosition;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.locale.Locale;
import me.alexdevs.solstice.modules.teleportRequest.TeleportRequest;
import me.alexdevs.solstice.modules.teleportRequest.TeleportRequestModule;
import net.minecraft.class_2168;
import net.minecraft.class_5242;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class TeleportAcceptCommand extends ModCommand<TeleportRequestModule> {
    private final Locale locale = Solstice.localeManager.getLocale(TeleportRequestModule.ID);

    public TeleportAcceptCommand(TeleportRequestModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("tpaccept", "tpyes");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var playerUuid = player.method_5667();
                    var playerRequests = module.teleportRequests.get(playerUuid);
                    var playerContext = PlaceholderContext.of(player);

                    var request = playerRequests.pollLast();

                    if (request == null) {
                        context.getSource().method_9226(() -> locale.get(
                                "noPending",
                                playerContext
                        ), false);
                        return 1;
                    }

                    execute(context, request);

                    return 1;
                })
                .then(method_9244("uuid", class_5242.method_27643())
                        .executes(context -> {
                            var player = context.getSource().method_9207();
                            var uuid = class_5242.method_27645(context, "uuid");
                            var playerUuid = player.method_5667();
                            var playerRequests = module.teleportRequests.get(playerUuid);
                            var playerContext = PlaceholderContext.of(player);

                            var request = playerRequests.stream().filter(req -> req.requestId.equals(uuid)).findFirst().orElse(null);
                            if (request == null) {
                                context.getSource().method_9226(() -> locale.get(
                                        "unavailable",
                                        playerContext
                                ), false);
                                return 1;
                            }

                            execute(context, request);

                            return 1;
                        }));
    }

    private void execute(CommandContext<class_2168> context, TeleportRequest request) {
        var source = context.getSource();
        request.expire();

        var player = source.method_44023();

        var playerManager = context.getSource().method_9211().method_3760();

        var sourcePlayer = playerManager.method_14602(request.player);
        var targetPlayer = playerManager.method_14602(request.target);

        var playerContext = PlaceholderContext.of(player);

        if (sourcePlayer == null || targetPlayer == null) {
            context.getSource().method_9226(() -> locale.get(
                    "playerUnavailable",
                    playerContext
            ), false);
            return;
        }

        if (player.method_5667().equals(request.target)) {
            var sourceContext = PlaceholderContext.of(sourcePlayer);
            // accepted a tpa from other to self
            context.getSource().method_9226(() -> locale.get(
                    "requestAcceptedResult",
                    playerContext
            ), false);
            sourcePlayer.method_7353(locale.get(
                    "teleporting",
                    sourceContext
            ), false);
        } else {
            var targetContext = PlaceholderContext.of(targetPlayer);
            // accepted a tpa from self to other
            context.getSource().method_9226(() -> locale.get(
                    "teleporting",
                    playerContext
            ), false);

            targetPlayer.method_7353(locale.get(
                    "requestAccepted",
                    targetContext,
                    Map.of("player", sourcePlayer.method_5476())
            ), false);
        }

        var targetPosition = new ServerPosition(targetPlayer);
        targetPosition.teleport(sourcePlayer);
    }
}
