package me.alexdevs.solstice.modules.teleportRequest.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.locale.Locale;
import me.alexdevs.solstice.modules.ignore.IgnoreModule;
import me.alexdevs.solstice.modules.teleportRequest.TeleportRequest;
import me.alexdevs.solstice.modules.teleportRequest.TeleportRequestModule;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import me.alexdevs.solstice.api.text.Components;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class TeleportAskHereCommand extends ModCommand<TeleportRequestModule> {
    private final Locale locale = Solstice.localeManager.getLocale(TeleportRequestModule.ID);

    public TeleportAskHereCommand(TeleportRequestModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("tpahere", "tpaskhere");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require("here", true))
                .then(method_9244("player", StringArgumentType.word())
                        .suggests((context, builder) -> {
                            var playerManager = context.getSource().method_9211().method_3760();
                            return class_2172.method_9253(
                                    playerManager.method_14580(),
                                    builder);
                        })
                        .executes(this::execute));
    }

    private int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        var source = context.getSource();
        var player = context.getSource().method_9207();
        var server = source.method_9211();
        var targetName = StringArgumentType.getString(context, "player");
        var playerManager = server.method_3760();
        var target = playerManager.method_14566(targetName);
        var playerContext = PlaceholderContext.of(player);
        if (target == null) {
            var placeholders = Map.of(
                    "targetPlayer", class_2561.method_30163(targetName)
            );
            source.method_9226(() -> locale.get(
                    "playerNotFound",
                    playerContext,
                    placeholders
            ), false);
            return 0;
        }

        var ignoreModule = Solstice.modules.getModule(IgnoreModule.class);
        if (ignoreModule.getPlayerData(target.method_5667()).ignoredPlayers.contains(player.method_5667())) {
            return 0;
        }

        var request = new TeleportRequest(target.method_5667(), player.method_5667());
        var targetRequests = module.teleportRequests.get(target.method_5667());
        targetRequests.addLast(request);

        var targetContext = PlaceholderContext.of(target);
        var placeholders = Map.of(
                "requesterPlayer", player.method_5476(),
                "acceptButton", Components.button(
                        locale.raw("~accept"),
                        locale.raw("~hoverAccept"),
                        "/tpaccept " + request.requestId),
                "refuseButton", Components.button(
                        locale.raw("~refuse"),
                        locale.raw("~hoverRefuse"),
                        "/tpdeny " + request.requestId)
        );

        target.method_43496(locale.get(
                "pendingTeleportHere",
                targetContext,
                placeholders
        ));

        source.method_9226(() -> locale.get(
                "requestSent",
                playerContext
        ), false);

        return 1;
    }
}
