package me.alexdevs.solstice.modules.teleportRequest.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.locale.Locale;
import me.alexdevs.solstice.modules.teleportRequest.TeleportRequest;
import me.alexdevs.solstice.modules.teleportRequest.TeleportRequestModule;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class TeleportDenyCommand extends ModCommand<TeleportRequestModule> {
    private final Locale locale = Solstice.localeManager.getLocale(TeleportRequestModule.ID);

    public TeleportDenyCommand(TeleportRequestModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("tpdeny", "tpno", "tprefuse");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var playerUuid = player.method_5667();
                    var playerRequests = module.teleportRequests.get(playerUuid);
                    var playerContext = PlaceholderContext.of(player);

                    var request = playerRequests.pollLast();

                    if (request == null) {
                        context.getSource().method_9226(() -> locale.get(
                                "noPending",
                                playerContext
                        ), false);
                        return 1;
                    }

                    execute(context, request);

                    return 1;
                })
                .then(method_9244("uuid", class_5242.method_27643())
                        .executes(context -> {
                            var player = context.getSource().method_9207();
                            var uuid = class_5242.method_27645(context, "uuid");
                            var playerUuid = player.method_5667();
                            var playerRequests = module.teleportRequests.get(playerUuid);
                            var playerContext = PlaceholderContext.of(player);

                            var request = playerRequests.stream().filter(req -> req.requestId.equals(uuid)).findFirst().orElse(null);
                            if (request == null) {
                                context.getSource().method_9226(() -> locale.get(
                                        "unavailable",
                                        playerContext
                                ), false);
                                return 1;
                            }

                            execute(context, request);

                            return 1;
                        }));
    }

    private void execute(CommandContext<class_2168> context, TeleportRequest request) {
        var source = context.getSource();
        request.expire();

        var player = source.method_44023();
        var playerManager = context.getSource().method_9211().method_3760();
        var playerContext = PlaceholderContext.of(player);

        class_3222 otherPlayer = null;
        if (player.method_5667().equals(request.target)) {
            otherPlayer = playerManager.method_14602(request.player);
        } else if (player.method_5667().equals(request.player)) {
            otherPlayer = playerManager.method_14602(request.target);
        }

        if (otherPlayer != null) {
            var otherContext = PlaceholderContext.of(otherPlayer);
            otherPlayer.method_7353(locale.get(
                    "requestRefused",
                    otherContext,
                    Map.of("player", player.method_5476())
            ), false);
        }

        context.getSource().method_9226(() -> locale.get(
                "requestRefusedResult",
                playerContext
        ), false);
    }
}
