package me.alexdevs.solstice.modules.tell;

import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.ignore.IgnoreModule;
import me.alexdevs.solstice.modules.tell.commands.ReplyCommand;
import me.alexdevs.solstice.modules.tell.commands.TellCommand;
import me.alexdevs.solstice.modules.tell.data.TellLocale;
import me.alexdevs.solstice.api.text.Components;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.util.HashMap;
import java.util.Map;

public class TellModule extends ModuleBase {
    public static final String ID = "tell";
    public final HashMap<String, String> lastSender = new HashMap<>();

    public TellModule() {
        super(ID);

        Solstice.localeManager.registerModule(ID, TellLocale.MODULE);

        commands.add(new TellCommand(this));
        commands.add(new ReplyCommand(this));
    }

    public void sendDirectMessage(String targetName, class_2168 source, String message) {
        var locale = Solstice.localeManager.getLocale(ID);
        class_2561 targetDisplayName;
        class_3222 targetPlayer = null;
        if (targetName.equalsIgnoreCase("server")) {
            targetDisplayName = class_2561.method_30163("Server");
        } else {
            targetPlayer = source.method_9211().method_3760().method_14566(targetName);
            if (targetPlayer == null) {
                var placeholders = Map.of(
                        "targetPlayer", class_2561.method_30163(targetName)
                );
                var sourceContext = PlaceholderContext.of(source);

                source.method_9226(() -> locale.get(
                        "playerNotFound",
                        sourceContext,
                        placeholders
                ), false);
                return;
            }
            targetDisplayName = targetPlayer.method_5476();
        }

        var parsedMessage = Components.chat(message, source);

        var serverContext = PlaceholderContext.of(source.method_9211());
        var sourceContext = PlaceholderContext.of(source);
        PlaceholderContext targetContext;
        if (targetPlayer == null) {
            targetContext = serverContext;
        } else {
            targetContext = PlaceholderContext.of(targetPlayer);
        }


        var you = locale.get("you");

        var placeholdersToSource = Map.of(
                "sourcePlayer", you,
                "targetPlayer", targetDisplayName,
                "message", parsedMessage
        );

        var placeholdersToTarget = Map.of(
                "sourcePlayer", source.method_9223(),
                "targetPlayer", you,
                "message", parsedMessage
        );

        var placeholders = Map.of(
                "sourcePlayer", source.method_9223(),
                "targetPlayer", targetDisplayName,
                "message", parsedMessage
        );

        var sourceText = locale.get(
                "message",
                sourceContext,
                placeholdersToSource
        );
        var targetText = locale.get(
                "message",
                targetContext,
                placeholdersToTarget
        );
        var genericText = locale.get(
                "message",
                serverContext,
                placeholders
        );
        var spyText = locale.get(
                "messageSpy",
                serverContext,
                placeholders
        );

        lastSender.put(targetName, source.method_9214());
        lastSender.put(source.method_9214(), targetName);

        if (!source.method_9214().equals(targetName)) {
            source.method_45068(sourceText);
        }
        if (targetPlayer != null) {
            var ignoreModule = Solstice.modules.getModule(IgnoreModule.class);
            if (!source.method_43737() || !ignoreModule.isIgnoring(targetPlayer, source.method_44023())) {
                targetPlayer.method_43496(targetText);
            }

            if (source.method_43737()) {
                source.method_9211().method_43496(genericText);
            }
        } else {
            // avoid duped message
            source.method_9211().method_43496(targetText);
        }

        source.method_9211().method_3760().method_14571().forEach(player -> {
            var playerName = player.method_7334().getName();
            if (playerName.equals(targetName) || playerName.equals(source.method_9214())) {
                return;
            }
            if (Permissions.check(player, getPermissionNode("spy"))) {
                player.method_43496(spyText);
            }
        });
    }
}
