package me.alexdevs.solstice.modules.tell.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.tell.TellModule;
import net.minecraft.class_2168;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;


public class ReplyCommand extends ModCommand<TellModule> {
    public ReplyCommand(TellModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("reply", "r");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .then(method_9244("message", StringArgumentType.greedyString())
                        .executes(this::execute));
    }

    private int execute(CommandContext<class_2168> context) {
        var source = context.getSource();
        var senderName = source.method_9214();
        var message = StringArgumentType.getString(context, "message");

        if (!module.lastSender.containsKey(senderName)) {
            var playerContext = PlaceholderContext.of(context.getSource());
            source.method_9226(() -> module.locale().get(
                    "noLastSenderReply",
                    playerContext
            ), false);
            return 1;
        }

        var targetName = module.lastSender.get(senderName);

        module.sendDirectMessage(targetName, source, message);

        return 1;
    }
}
