package me.alexdevs.solstice.modules.tell.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.module.Utils;
import me.alexdevs.solstice.modules.tell.TellModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_7157;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;


public class TellCommand extends ModCommand<TellModule> {
    public TellCommand(TellModule module) {
        super(module);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistry, class_2170.class_5364 environment) {
        Utils.removeCommands(dispatcher, "msg", "tell", "w");
        super.register(dispatcher, commandRegistry, environment);
    }

    @Override
    public List<String> getNames() {
        return List.of("tell", "msg", "w", "dm");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .then(method_9244("player", StringArgumentType.word())
                        .suggests((context, builder) -> {
                            var playerManager = context.getSource().method_9211().method_3760();
                            return class_2172.method_9253(
                                    playerManager.method_14580(),
                                    builder);
                        })
                        .then(method_9244("message", StringArgumentType.greedyString())
                                .executes(this::execute)));
    }

    private int execute(CommandContext<class_2168> context) {
        var source = context.getSource();
        var targetName = StringArgumentType.getString(context, "player");
        var message = StringArgumentType.getString(context, "message");

        module.sendDirectMessage(targetName, source, message);
        return 1;
    }
}
