package me.alexdevs.solstice.modules.timeBar;

import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.text.Format;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3002;
import java.util.Map;
import java.util.UUID;

public class TimeBar {
    private final UUID uuid = UUID.randomUUID();
    private final class_3002 bossBar;
    private final String label;
    private final int time;
    private final boolean countdown;
    private int elapsedSeconds = 0;

    public TimeBar(String label, int time, boolean countdown, class_1259.class_1260 color, class_1259.class_1261 style) {
        this.bossBar = new class_3002(class_2960.method_60655(Solstice.MOD_ID, uuid.toString()), class_2561.method_30163(label));
        this.bossBar.method_5416(color);
        this.bossBar.method_5409(style);
        this.label = label;
        this.time = time;
        this.countdown = countdown;
        updateName();
        updateProgress();
    }

    public static String formatTime(int totalSeconds) {
        var hours = totalSeconds / 3600;
        var minutes = (totalSeconds / 60) % 60;
        var seconds = totalSeconds % 60;
        if (totalSeconds >= 3600) {
            return String.format("%dh%dm%ds", hours, minutes, seconds);
        }
        return String.format("%dm%ds", minutes, seconds);
    }

    public void updateName() {
        var text = parseLabel(label);
        bossBar.method_5413(text);
    }

    public class_2561 parseLabel(String labelString) {
        var totalTime = formatTime(this.time);
        var elapsedTime = formatTime(this.elapsedSeconds);

        var remaining = getRemainingSeconds();
        var remainingTime = formatTime(remaining);

        var placeholders = Map.of(
                "total_time", class_2561.method_30163(totalTime),
                "elapsed_time", class_2561.method_30163(elapsedTime),
                "remaining_time", class_2561.method_30163(remainingTime)
        );

        var serverContext = PlaceholderContext.of(Solstice.server);

        return Format.parse(labelString, serverContext, placeholders);
    }

    public UUID getUuid() {
        return uuid;
    }

    public class_3002 getBossBar() {
        return bossBar;
    }

    public String getLabel() {
        return label;
    }

    public int getTime() {
        return time;
    }

    public int getElapsedSeconds() {
        return elapsedSeconds;
    }

    public int getRemainingSeconds() {
        return time - elapsedSeconds;
    }

    public boolean isCountdown() {
        return countdown;
    }

    public boolean elapse() {
        this.elapsedSeconds++;

        updateProgress();
        updateName();

        return this.elapsedSeconds >= this.time;
    }

    private void updateProgress() {
        float progress = (float) elapsedSeconds / (float) time;
        if (countdown) {
            progress = 1f - progress;
        }

        bossBar.method_5408(Math.min(
                Math.max(
                        progress,
                        0f),
                1f));
    }
}
