package me.alexdevs.solstice.modules.timeBar;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.TimeBarEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.timeBar.commands.TimeBarCommand;
import net.minecraft.class_1259;
import net.minecraft.class_3222;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;

public class TimeBarModule extends ModuleBase {
    public static final String ID = "timebar";
    private static final ConcurrentLinkedDeque<TimeBar> timeBars = new ConcurrentLinkedDeque<>();

    public TimeBarModule() {
        super(ID);

        commands.add(new TimeBarCommand(this));

        Solstice.scheduler.scheduleAtFixedRate(this::updateBars, 0, 1, TimeUnit.SECONDS);
    }

    public void updateBars() {
        for (var timeBar : timeBars) {
            var remove = timeBar.elapse();
            TimeBarEvents.PROGRESS.invoker().onProgress(timeBar, Solstice.server);

            var players = Solstice.server.method_3760().method_14571();
            showBar(players, timeBar);

            if (remove) {
                timeBars.remove(timeBar);
                TimeBarEvents.END.invoker().onEnd(timeBar, Solstice.server);
                hideBar(players, timeBar);
            }
        }
    }

    private void showBar(Collection<class_3222> players, TimeBar timeBar) {
        timeBar.getBossBar().method_12962(players);
    }

    private void hideBar(Collection<class_3222> players, TimeBar timeBar) {
        players.forEach(player -> {
            timeBar.getBossBar().method_14089(player);

        });
    }

    public TimeBar startTimeBar(String label, int seconds, class_1259.class_1260 color, class_1259.class_1261 style, boolean countdown) {
        var timeBar = new TimeBar(label, seconds, countdown, color, style);

        timeBars.add(timeBar);

        var players = Solstice.server.method_3760().method_14571();
        showBar(players, timeBar);

        TimeBarEvents.START.invoker().onStart(timeBar, Solstice.server);
        TimeBarEvents.PROGRESS.invoker().onProgress(timeBar, Solstice.server);

        return timeBar;
    }

    public boolean cancelTimeBar(TimeBar timeBar) {
        var success = timeBars.remove(timeBar);
        if (success) {
            var players = Solstice.server.method_3760().method_14571();
            hideBar(players, timeBar);
            TimeBarEvents.CANCEL.invoker().onCancel(timeBar, Solstice.server);
        }
        return success;
    }

    public boolean cancelTimeBar(UUID uuid) {
        var progressBar = timeBars.stream().filter(p -> p.getUuid().equals(uuid)).findFirst().orElse(null);
        if (progressBar == null) {
            return false;
        }

        return cancelTimeBar(progressBar);
    }
}
