package me.alexdevs.solstice.api;

import com.google.common.collect.ImmutableList;
import me.alexdevs.solstice.modules.ModuleProvider;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5275;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import java.util.Objects;

public class ServerLocation {
    protected final double x;
    protected final double y;
    protected final double z;
    protected final float yaw;
    protected final float pitch;
    protected final String world;

    private static final ImmutableList<class_2248> unsafeBlocks = ImmutableList.of(
            class_2246.field_10164,
            class_2246.field_10092,
            class_2246.field_10029,
            class_2246.field_10036,
            class_2246.field_17350,
            class_2246.field_27098,
            class_2246.field_16999,
            class_2246.field_27879
    );

    public static final int SAFE_RANGE = 5;

    public ServerLocation(double x, double y, double z, float yaw, float pitch, class_3218 world) {
        this(x, y, z, yaw, pitch, world.method_27983().method_29177().toString());
    }

    public ServerLocation(class_3222 player) {
        this(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), player.method_51469().method_27983().method_29177().toString());
    }

    public ServerLocation(double x, double y, double z, float yaw, float pitch, String worldKey) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.world = worldKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        ServerLocation that = (ServerLocation) o;
        return Double.compare(getX(), that.getX()) == 0 && Double.compare(getY(), that.getY()) == 0 && Double.compare(getZ(), that.getZ()) == 0 && Float.compare(getYaw(), that.getYaw()) == 0 && Float.compare(getPitch(), that.getPitch()) == 0 && Objects.equals(getWorld(), that.getWorld());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getX(), getY(), getZ(), getYaw(), getPitch(), getWorld());
    }

    public void teleport(class_3222 player, boolean setBackPosition) {
        if (setBackPosition) {
            var currentPosition = new ServerLocation(player);
            ModuleProvider.BACK.setPlayerLastLocation(player.method_5667(), currentPosition);
        }

        var serverWorld = getWorld(player.method_5682());

        player.method_18799(player.method_18798().method_18805(1f, 0f, 1f));
        player.method_24830(true);

        player.method_14251(serverWorld, this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());

        // There is a bug (presumably in Fabric's api) that causes experience level to be set to 0 when teleporting between dimensions/worlds.
        // Therefore, this will update the experience client side as a temporary solution.
        player.method_7255(0);
    }

    public void teleport(class_3222 player) {
        teleport(player, true);
    }

    public class_5321<class_1937> getWorldKey() {
        return class_5321.method_29179(class_7924.field_41223, class_2960.method_12829(this.getWorld()));
    }

    public class_3218 getWorld(MinecraftServer server) {
        return server.method_3847(getWorldKey());
    }

    public class_2338 getBlockPos() {
        return class_2338.method_49637(this.getX(), this.getY(), this.getZ());
    }

    public double getX() {
        return x;
    }

    public double getY() {
        return y;
    }

    public double getZ() {
        return z;
    }

    public float getYaw() {
        return yaw;
    }

    public float getPitch() {
        return pitch;
    }

    public String getWorld() {
        return world;
    }

    public double getDistance(ServerLocation other) {
        if (!other.getWorld().equals(this.getWorld())) {
            return Double.POSITIVE_INFINITY;
        }

        var thisVec = new class_243(this.getX(), this.getY(), this.getZ());
        var otherVec = new class_243(other.getX(), other.getY(), other.getZ());

        return thisVec.method_1022(otherVec);
    }

    public class_243 getDelta(ServerLocation other) {
        return new class_243(this.getX() - other.getX(), this.getY() - other.getY(), this.getZ() - other.getZ());
    }

    public boolean safeTeleport(class_3222 player, boolean setBackPosition, int range) {
        var world = getWorld(player.method_5682());

        var horRange = (int) Math.pow(range, 2);
        for (int i = 1; i <= horRange; i++) {
            var rel = spiral(i);
            var attemptPos = this.getBlockPos().method_10081(rel);
            for (int j = 0; j < range * 2; j++) {

                // Integer zigzag pattern: 0, 1, -1, 2, -2, 3, -3, ...
                var y = (j % 2 == 0) ? -j / 2 : j / 2 + 1;

                var safePos = class_5275.method_30769(class_1299.field_6097, world, attemptPos.method_10069(0, y, 0), true);
                if (safePos != null) {
                    var safeLocation = new ServerLocation(safePos.field_1352, safePos.field_1351, safePos.field_1350, this.getYaw(), this.getPitch(), this.getWorld());
                    safeLocation.teleport(player, setBackPosition);
                    return true;
                }
            }
        }

        return false;
    }

    public boolean safeTeleport(class_3222 player) {
        return safeTeleport(player, true, SAFE_RANGE);
    }

    /// [Algorithm to find a specific element coordinates in a spiral](https://stackoverflow.com/questions/61229890/algorithm-to-find-a-specific-elements-coordinate-in-a-spiral)
    public static class_2382 spiral(int n) {
        if (n == 0) {
            return class_2382.field_11176;
        }

        var k = (int) Math.ceil((Math.sqrt(n) - 1) / 2);
        var t = 2 * k + 1;
        var m = (int) Math.pow(t, 2);
        t = t - 1;

        if (n >= m - t) {
            var x = k - (m - n);
            var z = -k;
            return new class_2382(x, 0, z);
        } else {
            m = m - t;
        }

        if (n >= m - t) {
            var x = -k;
            var z = -k + (m - n);
            return new class_2382(x, 0, z);
        } else {
            m = m - t;
        }

        if (n >= m - t) {
            var x = -k + (m - n);
            var z = k;
            return new class_2382(x, 0, z);
        } else {
            var x = k;
            var z = k - (m - n - t);
            return new class_2382(x, 0, z);
        }
    }
}
